package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{AclUri, AclCanonicalId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AclGrantee(
    id: Optional[AclCanonicalId] = Optional.Absent,
    uri: Optional[AclUri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AclGrantee = {
    import AclGrantee.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AclGrantee
      .builder()
      .optionallyWith(
        id.map(value => AclCanonicalId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(uri.map(value => AclUri.unwrap(value): java.lang.String))(
        _.uri
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.AclGrantee.ReadOnly =
    zio.aws.accessanalyzer.model.AclGrantee.wrap(buildAwsValue())
}
object AclGrantee {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AclGrantee
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AclGrantee =
      zio.aws.accessanalyzer.model
        .AclGrantee(id.map(value => value), uri.map(value => value))
    def id: Optional[AclCanonicalId]
    def uri: Optional[AclUri]
    def getId: ZIO[Any, AwsError, AclCanonicalId] =
      AwsError.unwrapOptionField("id", id)
    def getUri: ZIO[Any, AwsError, AclUri] =
      AwsError.unwrapOptionField("uri", uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AclGrantee
  ) extends zio.aws.accessanalyzer.model.AclGrantee.ReadOnly {
    override val id: Optional[AclCanonicalId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives.AclCanonicalId(value)
      )
    override val uri: Optional[AclUri] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.accessanalyzer.model.primitives.AclUri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AclGrantee
  ): zio.aws.accessanalyzer.model.AclGrantee.ReadOnly = new Wrapper(impl)
}
