package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.AccessPreviewId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAccessPreviewResponse(id: AccessPreviewId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewResponse = {
    import CreateAccessPreviewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewResponse
      .builder()
      .id(AccessPreviewId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.CreateAccessPreviewResponse.ReadOnly =
    zio.aws.accessanalyzer.model.CreateAccessPreviewResponse
      .wrap(buildAwsValue())
}
object CreateAccessPreviewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CreateAccessPreviewResponse =
      zio.aws.accessanalyzer.model.CreateAccessPreviewResponse(id)
    def id: AccessPreviewId
    def getId: ZIO[Any, Nothing, AccessPreviewId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewResponse
  ) extends zio.aws.accessanalyzer.model.CreateAccessPreviewResponse.ReadOnly {
    override val id: AccessPreviewId =
      zio.aws.accessanalyzer.model.primitives.AccessPreviewId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewResponse
  ): zio.aws.accessanalyzer.model.CreateAccessPreviewResponse.ReadOnly =
    new Wrapper(impl)
}
