package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Criterion(
    contains: Optional[Iterable[String]] = Optional.Absent,
    eq: Optional[Iterable[String]] = Optional.Absent,
    exists: Optional[Boolean] = Optional.Absent,
    neq: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Criterion = {
    import Criterion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Criterion
      .builder()
      .optionallyWith(
        contains.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.contains)
      .optionallyWith(
        eq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eq)
      .optionallyWith(exists.map(value => value: java.lang.Boolean))(_.exists)
      .optionallyWith(
        neq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.neq)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Criterion.ReadOnly =
    zio.aws.accessanalyzer.model.Criterion.wrap(buildAwsValue())
}
object Criterion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Criterion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Criterion =
      zio.aws.accessanalyzer.model.Criterion(
        contains.map(value => value),
        eq.map(value => value),
        exists.map(value => value),
        neq.map(value => value)
      )
    def contains: Optional[List[String]]
    def eq: Optional[List[String]]
    def exists: Optional[Boolean]
    def neq: Optional[List[String]]
    def getContains: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("contains", contains)
    def getEq: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eq", eq)
    def getExists: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("exists", exists)
    def getNeq: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("neq", neq)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Criterion
  ) extends zio.aws.accessanalyzer.model.Criterion.ReadOnly {
    override val contains: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.contains())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eq: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eq())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val exists: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.exists())
      .map(value => value: Boolean)
    override val neq: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.neq())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Criterion
  ): zio.aws.accessanalyzer.model.Criterion.ReadOnly = new Wrapper(impl)
}
