package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VpcConfiguration(vpcId: VpcId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.VpcConfiguration = {
    import VpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.VpcConfiguration
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.VpcConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.VpcConfiguration.wrap(buildAwsValue())
}
object VpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.VpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.VpcConfiguration =
      zio.aws.accessanalyzer.model.VpcConfiguration(vpcId)
    def vpcId: VpcId
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.VpcConfiguration
  ) extends zio.aws.accessanalyzer.model.VpcConfiguration.ReadOnly {
    override val vpcId: VpcId =
      zio.aws.accessanalyzer.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.VpcConfiguration
  ): zio.aws.accessanalyzer.model.VpcConfiguration.ReadOnly = new Wrapper(impl)
}
