package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters._
sealed trait ReasonCode {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.ReasonCode
}
object ReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.ReasonCode
  ): zio.aws.accessanalyzer.model.ReasonCode = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.AWS_SERVICE_ACCESS_DISABLED =>
      val r = AWS_SERVICE_ACCESS_DISABLED
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.DELEGATED_ADMINISTRATOR_DEREGISTERED =>
      val r = DELEGATED_ADMINISTRATOR_DEREGISTERED
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.ORGANIZATION_DELETED =>
      val r = ORGANIZATION_DELETED
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.SERVICE_LINKED_ROLE_CREATION_FAILED =>
      val r = SERVICE_LINKED_ROLE_CREATION_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.ReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ReasonCode =
      software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_SERVICE_ACCESS_DISABLED
      extends zio.aws.accessanalyzer.model.ReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ReasonCode =
      software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.AWS_SERVICE_ACCESS_DISABLED
  }
  case object DELEGATED_ADMINISTRATOR_DEREGISTERED
      extends zio.aws.accessanalyzer.model.ReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ReasonCode =
      software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.DELEGATED_ADMINISTRATOR_DEREGISTERED
  }
  case object ORGANIZATION_DELETED
      extends zio.aws.accessanalyzer.model.ReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ReasonCode =
      software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.ORGANIZATION_DELETED
  }
  case object SERVICE_LINKED_ROLE_CREATION_FAILED
      extends zio.aws.accessanalyzer.model.ReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ReasonCode =
      software.amazon.awssdk.services.accessanalyzer.model.ReasonCode.SERVICE_LINKED_ROLE_CREATION_FAILED
  }
}
