package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Position(column: Integer, line: Integer, offset: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Position = {
    import Position.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Position
      .builder()
      .column(column: java.lang.Integer)
      .line(line: java.lang.Integer)
      .offset(offset: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Position.ReadOnly =
    zio.aws.accessanalyzer.model.Position.wrap(buildAwsValue())
}
object Position {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Position
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Position =
      zio.aws.accessanalyzer.model.Position(column, line, offset)
    def column: Integer
    def line: Integer
    def offset: Integer
    def getColumn: ZIO[Any, Nothing, Integer] = ZIO.succeed(column)
    def getLine: ZIO[Any, Nothing, Integer] = ZIO.succeed(line)
    def getOffset: ZIO[Any, Nothing, Integer] = ZIO.succeed(offset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Position
  ) extends zio.aws.accessanalyzer.model.Position.ReadOnly {
    override val column: Integer = impl.column(): Integer
    override val line: Integer = impl.line(): Integer
    override val offset: Integer = impl.offset(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Position
  ): zio.aws.accessanalyzer.model.Position.ReadOnly = new Wrapper(impl)
}
