package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.JobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGeneratedPolicyRequest(
    includeResourcePlaceholders: Optional[Boolean] = Optional.Absent,
    includeServiceLevelTemplate: Optional[Boolean] = Optional.Absent,
    jobId: JobId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyRequest = {
    import GetGeneratedPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyRequest
      .builder()
      .optionallyWith(
        includeResourcePlaceholders.map(value => value: java.lang.Boolean)
      )(_.includeResourcePlaceholders)
      .optionallyWith(
        includeServiceLevelTemplate.map(value => value: java.lang.Boolean)
      )(_.includeServiceLevelTemplate)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.GetGeneratedPolicyRequest.ReadOnly =
    zio.aws.accessanalyzer.model.GetGeneratedPolicyRequest.wrap(buildAwsValue())
}
object GetGeneratedPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetGeneratedPolicyRequest =
      zio.aws.accessanalyzer.model.GetGeneratedPolicyRequest(
        includeResourcePlaceholders.map(value => value),
        includeServiceLevelTemplate.map(value => value),
        jobId
      )
    def includeResourcePlaceholders: Optional[Boolean]
    def includeServiceLevelTemplate: Optional[Boolean]
    def jobId: JobId
    def getIncludeResourcePlaceholders: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "includeResourcePlaceholders",
        includeResourcePlaceholders
      )
    def getIncludeServiceLevelTemplate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "includeServiceLevelTemplate",
        includeServiceLevelTemplate
      )
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyRequest
  ) extends zio.aws.accessanalyzer.model.GetGeneratedPolicyRequest.ReadOnly {
    override val includeResourcePlaceholders: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeResourcePlaceholders())
        .map(value => value: Boolean)
    override val includeServiceLevelTemplate: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeServiceLevelTemplate())
        .map(value => value: Boolean)
    override val jobId: JobId =
      zio.aws.accessanalyzer.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyRequest
  ): zio.aws.accessanalyzer.model.GetGeneratedPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
