package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetGeneratedPolicyResponse(
    generatedPolicyResult: zio.aws.accessanalyzer.model.GeneratedPolicyResult,
    jobDetails: zio.aws.accessanalyzer.model.JobDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse = {
    import GetGeneratedPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse
      .builder()
      .generatedPolicyResult(generatedPolicyResult.buildAwsValue())
      .jobDetails(jobDetails.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly =
    zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse
      .wrap(buildAwsValue())
}
object GetGeneratedPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse =
      zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse(
        generatedPolicyResult.asEditable,
        jobDetails.asEditable
      )
    def generatedPolicyResult
        : zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly
    def jobDetails: zio.aws.accessanalyzer.model.JobDetails.ReadOnly
    def getGeneratedPolicyResult: ZIO[
      Any,
      Nothing,
      zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly
    ] = ZIO.succeed(generatedPolicyResult)
    def getJobDetails
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.JobDetails.ReadOnly] =
      ZIO.succeed(jobDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse
  ) extends zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly {
    override val generatedPolicyResult
        : zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly =
      zio.aws.accessanalyzer.model.GeneratedPolicyResult
        .wrap(impl.generatedPolicyResult())
    override val jobDetails: zio.aws.accessanalyzer.model.JobDetails.ReadOnly =
      zio.aws.accessanalyzer.model.JobDetails.wrap(impl.jobDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyResponse
  ): zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
