package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAnalyzerRequest(analyzerName: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest = {
    import GetAnalyzerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.GetAnalyzerRequest.ReadOnly =
    zio.aws.accessanalyzer.model.GetAnalyzerRequest.wrap(buildAwsValue())
}
object GetAnalyzerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetAnalyzerRequest =
      zio.aws.accessanalyzer.model.GetAnalyzerRequest(analyzerName)
    def analyzerName: Name
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest
  ) extends zio.aws.accessanalyzer.model.GetAnalyzerRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest
  ): zio.aws.accessanalyzer.model.GetAnalyzerRequest.ReadOnly = new Wrapper(
    impl
  )
}
