package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters._
sealed trait FindingChangeType {
  def unwrap
      : software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType
}
object FindingChangeType {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType
  ): zio.aws.accessanalyzer.model.FindingChangeType = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType.CHANGED =>
      val r = CHANGED
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType.NEW =>
      val r = NEW
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType.UNCHANGED =>
      val r = UNCHANGED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.FindingChangeType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType =
      software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType.UNKNOWN_TO_SDK_VERSION
  }
  case object CHANGED extends zio.aws.accessanalyzer.model.FindingChangeType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType =
      software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType.CHANGED
  }
  case object NEW extends zio.aws.accessanalyzer.model.FindingChangeType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType =
      software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType.NEW
  }
  case object UNCHANGED extends zio.aws.accessanalyzer.model.FindingChangeType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType =
      software.amazon.awssdk.services.accessanalyzer.model.FindingChangeType.UNCHANGED
  }
}
