package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.AccessPointPolicy
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3AccessPointConfiguration(
    accessPointPolicy: Optional[AccessPointPolicy] = Optional.Absent,
    networkOrigin: Optional[
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration
    ] = Optional.Absent,
    publicAccessBlock: Optional[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration = {
    import S3AccessPointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration
      .builder()
      .optionallyWith(
        accessPointPolicy.map(value =>
          AccessPointPolicy.unwrap(value): java.lang.String
        )
      )(_.accessPointPolicy)
      .optionallyWith(networkOrigin.map(value => value.buildAwsValue()))(
        _.networkOrigin
      )
      .optionallyWith(publicAccessBlock.map(value => value.buildAwsValue()))(
        _.publicAccessBlock
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.S3AccessPointConfiguration
      .wrap(buildAwsValue())
}
object S3AccessPointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.S3AccessPointConfiguration =
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration(
        accessPointPolicy.map(value => value),
        networkOrigin.map(value => value.asEditable),
        publicAccessBlock.map(value => value.asEditable)
      )
    def accessPointPolicy: Optional[AccessPointPolicy]
    def networkOrigin: Optional[
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly
    ]
    def publicAccessBlock: Optional[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ]
    def getAccessPointPolicy: ZIO[Any, AwsError, AccessPointPolicy] =
      AwsError.unwrapOptionField("accessPointPolicy", accessPointPolicy)
    def getNetworkOrigin: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkOrigin", networkOrigin)
    def getPublicAccessBlock: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("publicAccessBlock", publicAccessBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration
  ) extends zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly {
    override val accessPointPolicy: Optional[AccessPointPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPointPolicy())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives.AccessPointPolicy(value)
        )
    override val networkOrigin: Optional[
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkOrigin())
      .map(value =>
        zio.aws.accessanalyzer.model.NetworkOriginConfiguration.wrap(value)
      )
    override val publicAccessBlock: Optional[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.publicAccessBlock())
      .map(value =>
        zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration
  ): zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly =
    new Wrapper(impl)
}
