package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkOriginConfiguration(
    internetConfiguration: Optional[
      zio.aws.accessanalyzer.model.InternetConfiguration
    ] = Optional.Absent,
    vpcConfiguration: Optional[zio.aws.accessanalyzer.model.VpcConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration = {
    import NetworkOriginConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration
      .builder()
      .optionallyWith(
        internetConfiguration.map(value => value.buildAwsValue())
      )(_.internetConfiguration)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.NetworkOriginConfiguration
      .wrap(buildAwsValue())
}
object NetworkOriginConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.NetworkOriginConfiguration =
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration(
        internetConfiguration.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable)
      )
    def internetConfiguration
        : Optional[zio.aws.accessanalyzer.model.InternetConfiguration.ReadOnly]
    def vpcConfiguration
        : Optional[zio.aws.accessanalyzer.model.VpcConfiguration.ReadOnly]
    def getInternetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.InternetConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("internetConfiguration", internetConfiguration)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.VpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration
  ) extends zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly {
    override val internetConfiguration: Optional[
      zio.aws.accessanalyzer.model.InternetConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.internetConfiguration())
      .map(value =>
        zio.aws.accessanalyzer.model.InternetConfiguration.wrap(value)
      )
    override val vpcConfiguration
        : Optional[zio.aws.accessanalyzer.model.VpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.accessanalyzer.model.VpcConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.NetworkOriginConfiguration
  ): zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly =
    new Wrapper(impl)
}
