package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.IamTrustPolicy
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IamRoleConfiguration(
    trustPolicy: Optional[IamTrustPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.IamRoleConfiguration = {
    import IamRoleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.IamRoleConfiguration
      .builder()
      .optionallyWith(
        trustPolicy.map(value => IamTrustPolicy.unwrap(value): java.lang.String)
      )(_.trustPolicy)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.IamRoleConfiguration.wrap(buildAwsValue())
}
object IamRoleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.IamRoleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.IamRoleConfiguration =
      zio.aws.accessanalyzer.model
        .IamRoleConfiguration(trustPolicy.map(value => value))
    def trustPolicy: Optional[IamTrustPolicy]
    def getTrustPolicy: ZIO[Any, AwsError, IamTrustPolicy] =
      AwsError.unwrapOptionField("trustPolicy", trustPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.IamRoleConfiguration
  ) extends zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly {
    override val trustPolicy: Optional[IamTrustPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.trustPolicy())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives.IamTrustPolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.IamRoleConfiguration
  ): zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
