package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListArchiveRulesResponse(
    archiveRules: Iterable[zio.aws.accessanalyzer.model.ArchiveRuleSummary],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse = {
    import ListArchiveRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse
      .builder()
      .archiveRules(archiveRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListArchiveRulesResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ListArchiveRulesResponse.wrap(buildAwsValue())
}
object ListArchiveRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListArchiveRulesResponse =
      zio.aws.accessanalyzer.model.ListArchiveRulesResponse(
        archiveRules.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def archiveRules
        : List[zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly]
    def nextToken: Optional[Token]
    def getArchiveRules: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly
    ]] = ZIO.succeed(archiveRules)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse
  ) extends zio.aws.accessanalyzer.model.ListArchiveRulesResponse.ReadOnly {
    override val archiveRules
        : List[zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly] = impl
      .archiveRules()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.ArchiveRuleSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse
  ): zio.aws.accessanalyzer.model.ListArchiveRulesResponse.ReadOnly =
    new Wrapper(impl)
}
