package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccessPreviewFindingsResponse(
    findings: Iterable[zio.aws.accessanalyzer.model.AccessPreviewFinding],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse = {
    import ListAccessPreviewFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse
      .builder()
      .findings(findings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse
      .wrap(buildAwsValue())
}
object ListAccessPreviewFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse =
      zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse(
        findings.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def findings
        : List[zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly]
    def nextToken: Optional[Token]
    def getFindings: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly
    ]] = ZIO.succeed(findings)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse
  ) extends zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse.ReadOnly {
    override val findings
        : List[zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly] =
      impl
        .findings()
        .asScala
        .map { item =>
          zio.aws.accessanalyzer.model.AccessPreviewFinding.wrap(item)
        }
        .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse
  ): zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse.ReadOnly =
    new Wrapper(impl)
}
