package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelPolicyGenerationRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationRequest = {
    import CancelPolicyGenerationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.CancelPolicyGenerationRequest.ReadOnly =
    zio.aws.accessanalyzer.model.CancelPolicyGenerationRequest
      .wrap(buildAwsValue())
}
object CancelPolicyGenerationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CancelPolicyGenerationRequest =
      zio.aws.accessanalyzer.model.CancelPolicyGenerationRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationRequest
  ) extends zio.aws.accessanalyzer.model.CancelPolicyGenerationRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.accessanalyzer.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationRequest
  ): zio.aws.accessanalyzer.model.CancelPolicyGenerationRequest.ReadOnly =
    new Wrapper(impl)
}
