package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Name, AnalyzerArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplyArchiveRuleRequest(
    analyzerArn: AnalyzerArn,
    clientToken: Optional[String] = Optional.Absent,
    ruleName: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest = {
    import ApplyArchiveRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest.wrap(buildAwsValue())
}
object ApplyArchiveRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest =
      zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest(
        analyzerArn,
        clientToken.map(value => value),
        ruleName
      )
    def analyzerArn: AnalyzerArn
    def clientToken: Optional[String]
    def ruleName: Name
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest
  ) extends zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest
  ): zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest.ReadOnly =
    new Wrapper(impl)
}
