package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{S3BucketPolicy, AccessPointArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3BucketConfiguration(
    accessPoints: Optional[Map[
      AccessPointArn,
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration
    ]] = Optional.Absent,
    bucketAclGrants: Optional[
      Iterable[zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration]
    ] = Optional.Absent,
    bucketPolicy: Optional[S3BucketPolicy] = Optional.Absent,
    bucketPublicAccessBlock: Optional[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration = {
    import S3BucketConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration
      .builder()
      .optionallyWith(
        accessPoints.map(value =>
          value
            .map({ case (key, value) =>
              (AccessPointArn.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.accessPoints)
      .optionallyWith(
        bucketAclGrants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bucketAclGrants)
      .optionallyWith(
        bucketPolicy.map(value =>
          S3BucketPolicy.unwrap(value): java.lang.String
        )
      )(_.bucketPolicy)
      .optionallyWith(
        bucketPublicAccessBlock.map(value => value.buildAwsValue())
      )(_.bucketPublicAccessBlock)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.S3BucketConfiguration.wrap(buildAwsValue())
}
object S3BucketConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.S3BucketConfiguration =
      zio.aws.accessanalyzer.model.S3BucketConfiguration(
        accessPoints.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        bucketAclGrants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bucketPolicy.map(value => value),
        bucketPublicAccessBlock.map(value => value.asEditable)
      )
    def accessPoints: Optional[Map[
      AccessPointArn,
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly
    ]]
    def bucketAclGrants: Optional[
      List[zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly]
    ]
    def bucketPolicy: Optional[S3BucketPolicy]
    def bucketPublicAccessBlock: Optional[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ]
    def getAccessPoints: ZIO[Any, AwsError, Map[
      AccessPointArn,
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("accessPoints", accessPoints)
    def getBucketAclGrants: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("bucketAclGrants", bucketAclGrants)
    def getBucketPolicy: ZIO[Any, AwsError, S3BucketPolicy] =
      AwsError.unwrapOptionField("bucketPolicy", bucketPolicy)
    def getBucketPublicAccessBlock: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketPublicAccessBlock",
      bucketPublicAccessBlock
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration
  ) extends zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly {
    override val accessPoints: Optional[Map[
      AccessPointArn,
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPoints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.accessanalyzer.model.primitives.AccessPointArn(
              key
            ) -> zio.aws.accessanalyzer.model.S3AccessPointConfiguration
              .wrap(value)
          })
          .toMap
      )
    override val bucketAclGrants: Optional[
      List[zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketAclGrants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.wrap(item)
        }.toList
      )
    override val bucketPolicy: Optional[S3BucketPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPolicy())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives.S3BucketPolicy(value)
      )
    override val bucketPublicAccessBlock: Optional[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPublicAccessBlock())
      .map(value =>
        zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration
  ): zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
