package zio.aws.accessanalyzer
import zio.aws.accessanalyzer.model.FindingSummary.ReadOnly
import zio.aws.accessanalyzer.model.{
  GetAnalyzedResourceRequest,
  ApplyArchiveRuleRequest,
  ListAnalyzedResourcesRequest,
  ListAccessPreviewsRequest,
  ValidatePolicyRequest,
  CreateAnalyzerRequest,
  ListPolicyGenerationsRequest,
  StartResourceScanRequest,
  ListAnalyzersRequest,
  GetFindingRequest,
  ListTagsForResourceRequest,
  GetArchiveRuleRequest,
  UpdateArchiveRuleRequest,
  GetGeneratedPolicyRequest,
  ListFindingsRequest,
  ListAccessPreviewFindingsRequest,
  StartPolicyGenerationRequest,
  DeleteAnalyzerRequest,
  GetAccessPreviewRequest,
  GetAnalyzerRequest,
  UntagResourceRequest,
  CreateArchiveRuleRequest,
  CancelPolicyGenerationRequest,
  UpdateFindingsRequest,
  ListArchiveRulesRequest,
  TagResourceRequest,
  DeleteArchiveRuleRequest,
  CreateAccessPreviewRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient
import zio.stream.ZStream
object AccessAnalyzerMock extends Mock[AccessAnalyzer] {
  object ListAnalyzedResources
      extends Stream[
        ListAnalyzedResourcesRequest,
        AwsError,
        zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly
      ]
  object ListAnalyzedResourcesPaginated
      extends Effect[
        ListAnalyzedResourcesRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse.ReadOnly
      ]
  object ListFindings extends Stream[ListFindingsRequest, AwsError, ReadOnly]
  object ListFindingsPaginated
      extends Effect[
        ListFindingsRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ListFindingsResponse.ReadOnly
      ]
  object CreateAnalyzer
      extends Effect[
        CreateAnalyzerRequest,
        AwsError,
        zio.aws.accessanalyzer.model.CreateAnalyzerResponse.ReadOnly
      ]
  object DeleteAnalyzer extends Effect[DeleteAnalyzerRequest, AwsError, Unit]
  object StartResourceScan
      extends Effect[StartResourceScanRequest, AwsError, Unit]
  object CancelPolicyGeneration
      extends Effect[
        CancelPolicyGenerationRequest,
        AwsError,
        zio.aws.accessanalyzer.model.CancelPolicyGenerationResponse.ReadOnly
      ]
  object UpdateArchiveRule
      extends Effect[UpdateArchiveRuleRequest, AwsError, Unit]
  object ListArchiveRules
      extends Stream[
        ListArchiveRulesRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly
      ]
  object ListArchiveRulesPaginated
      extends Effect[
        ListArchiveRulesRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ListArchiveRulesResponse.ReadOnly
      ]
  object GetArchiveRule
      extends Effect[
        GetArchiveRuleRequest,
        AwsError,
        zio.aws.accessanalyzer.model.GetArchiveRuleResponse.ReadOnly
      ]
  object GetAnalyzedResource
      extends Effect[
        GetAnalyzedResourceRequest,
        AwsError,
        zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse.ReadOnly
      ]
  object GetGeneratedPolicy
      extends Effect[
        GetGeneratedPolicyRequest,
        AwsError,
        zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly
      ]
  object GetFinding
      extends Effect[
        GetFindingRequest,
        AwsError,
        zio.aws.accessanalyzer.model.GetFindingResponse.ReadOnly
      ]
  object CreateAccessPreview
      extends Effect[
        CreateAccessPreviewRequest,
        AwsError,
        zio.aws.accessanalyzer.model.CreateAccessPreviewResponse.ReadOnly
      ]
  object StartPolicyGeneration
      extends Effect[
        StartPolicyGenerationRequest,
        AwsError,
        zio.aws.accessanalyzer.model.StartPolicyGenerationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.accessanalyzer.model.UntagResourceResponse.ReadOnly
      ]
  object UpdateFindings extends Effect[UpdateFindingsRequest, AwsError, Unit]
  object GetAccessPreview
      extends Effect[
        GetAccessPreviewRequest,
        AwsError,
        zio.aws.accessanalyzer.model.GetAccessPreviewResponse.ReadOnly
      ]
  object ListAccessPreviewFindings
      extends Stream[
        ListAccessPreviewFindingsRequest,
        AwsError,
        zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly
      ]
  object ListAccessPreviewFindingsPaginated
      extends Effect[
        ListAccessPreviewFindingsRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse.ReadOnly
      ]
  object ApplyArchiveRule
      extends Effect[ApplyArchiveRuleRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.accessanalyzer.model.TagResourceResponse.ReadOnly
      ]
  object DeleteArchiveRule
      extends Effect[DeleteArchiveRuleRequest, AwsError, Unit]
  object ListAccessPreviews
      extends Stream[
        ListAccessPreviewsRequest,
        AwsError,
        zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly
      ]
  object ListAccessPreviewsPaginated
      extends Effect[
        ListAccessPreviewsRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ListAccessPreviewsResponse.ReadOnly
      ]
  object GetAnalyzer
      extends Effect[
        GetAnalyzerRequest,
        AwsError,
        zio.aws.accessanalyzer.model.GetAnalyzerResponse.ReadOnly
      ]
  object ListAnalyzers
      extends Stream[
        ListAnalyzersRequest,
        AwsError,
        zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly
      ]
  object ListAnalyzersPaginated
      extends Effect[
        ListAnalyzersRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ListAnalyzersResponse.ReadOnly
      ]
  object ValidatePolicy
      extends Stream[
        ValidatePolicyRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly
      ]
  object ValidatePolicyPaginated
      extends Effect[
        ValidatePolicyRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ValidatePolicyResponse.ReadOnly
      ]
  object CreateArchiveRule
      extends Effect[CreateArchiveRuleRequest, AwsError, Unit]
  object ListPolicyGenerations
      extends Stream[
        ListPolicyGenerationsRequest,
        AwsError,
        zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly
      ]
  object ListPolicyGenerationsPaginated
      extends Effect[
        ListPolicyGenerationsRequest,
        AwsError,
        zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AccessAnalyzer] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new AccessAnalyzer {
          val api: AccessAnalyzerAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : AccessAnalyzer = this
          def listAnalyzedResources(
              request: ListAnalyzedResourcesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListAnalyzedResources, request))
          def listAnalyzedResourcesPaginated(
              request: ListAnalyzedResourcesRequest
          ): IO[
            AwsError,
            zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse.ReadOnly
          ] = proxy(ListAnalyzedResourcesPaginated, request)
          def listFindings(
              request: ListFindingsRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(ListFindings, request))
          def listFindingsPaginated(request: ListFindingsRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.ListFindingsResponse.ReadOnly
          ] = proxy(ListFindingsPaginated, request)
          def createAnalyzer(request: CreateAnalyzerRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.CreateAnalyzerResponse.ReadOnly
          ] = proxy(CreateAnalyzer, request)
          def deleteAnalyzer(
              request: DeleteAnalyzerRequest
          ): IO[AwsError, Unit] = proxy(DeleteAnalyzer, request)
          def startResourceScan(
              request: StartResourceScanRequest
          ): IO[AwsError, Unit] = proxy(StartResourceScan, request)
          def cancelPolicyGeneration(
              request: CancelPolicyGenerationRequest
          ): IO[
            AwsError,
            zio.aws.accessanalyzer.model.CancelPolicyGenerationResponse.ReadOnly
          ] = proxy(CancelPolicyGeneration, request)
          def updateArchiveRule(
              request: UpdateArchiveRuleRequest
          ): IO[AwsError, Unit] = proxy(UpdateArchiveRule, request)
          def listArchiveRules(request: ListArchiveRulesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListArchiveRules, request))
          def listArchiveRulesPaginated(request: ListArchiveRulesRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.ListArchiveRulesResponse.ReadOnly
          ] = proxy(ListArchiveRulesPaginated, request)
          def getArchiveRule(request: GetArchiveRuleRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.GetArchiveRuleResponse.ReadOnly
          ] = proxy(GetArchiveRule, request)
          def getAnalyzedResource(request: GetAnalyzedResourceRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse.ReadOnly
          ] = proxy(GetAnalyzedResource, request)
          def getGeneratedPolicy(request: GetGeneratedPolicyRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly
          ] = proxy(GetGeneratedPolicy, request)
          def getFinding(request: GetFindingRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.GetFindingResponse.ReadOnly
          ] = proxy(GetFinding, request)
          def createAccessPreview(request: CreateAccessPreviewRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.CreateAccessPreviewResponse.ReadOnly
          ] = proxy(CreateAccessPreview, request)
          def startPolicyGeneration(request: StartPolicyGenerationRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.StartPolicyGenerationResponse.ReadOnly
          ] = proxy(StartPolicyGeneration, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def updateFindings(
              request: UpdateFindingsRequest
          ): IO[AwsError, Unit] = proxy(UpdateFindings, request)
          def getAccessPreview(request: GetAccessPreviewRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.GetAccessPreviewResponse.ReadOnly
          ] = proxy(GetAccessPreview, request)
          def listAccessPreviewFindings(
              request: ListAccessPreviewFindingsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly
          ] = rts.unsafeRun(proxy(ListAccessPreviewFindings, request))
          def listAccessPreviewFindingsPaginated(
              request: ListAccessPreviewFindingsRequest
          ): IO[
            AwsError,
            zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse.ReadOnly
          ] = proxy(ListAccessPreviewFindingsPaginated, request)
          def applyArchiveRule(
              request: ApplyArchiveRuleRequest
          ): IO[AwsError, Unit] = proxy(ApplyArchiveRule, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def deleteArchiveRule(
              request: DeleteArchiveRuleRequest
          ): IO[AwsError, Unit] = proxy(DeleteArchiveRule, request)
          def listAccessPreviews(request: ListAccessPreviewsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListAccessPreviews, request))
          def listAccessPreviewsPaginated(
              request: ListAccessPreviewsRequest
          ): IO[
            AwsError,
            zio.aws.accessanalyzer.model.ListAccessPreviewsResponse.ReadOnly
          ] = proxy(ListAccessPreviewsPaginated, request)
          def getAnalyzer(request: GetAnalyzerRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.GetAnalyzerResponse.ReadOnly
          ] = proxy(GetAnalyzer, request)
          def listAnalyzers(request: ListAnalyzersRequest): ZStream[
            Any,
            AwsError,
            zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListAnalyzers, request))
          def listAnalyzersPaginated(request: ListAnalyzersRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.ListAnalyzersResponse.ReadOnly
          ] = proxy(ListAnalyzersPaginated, request)
          def validatePolicy(request: ValidatePolicyRequest): ZStream[
            Any,
            AwsError,
            zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly
          ] = rts.unsafeRun(proxy(ValidatePolicy, request))
          def validatePolicyPaginated(request: ValidatePolicyRequest): IO[
            AwsError,
            zio.aws.accessanalyzer.model.ValidatePolicyResponse.ReadOnly
          ] = proxy(ValidatePolicyPaginated, request)
          def createArchiveRule(
              request: CreateArchiveRuleRequest
          ): IO[AwsError, Unit] = proxy(CreateArchiveRule, request)
          def listPolicyGenerations(
              request: ListPolicyGenerationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly
          ] = rts.unsafeRun(proxy(ListPolicyGenerations, request))
          def listPolicyGenerationsPaginated(
              request: ListPolicyGenerationsRequest
          ): IO[
            AwsError,
            zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly
          ] = proxy(ListPolicyGenerationsPaginated, request)
        }
      }
    }
  }
}
