package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartPolicyGenerationRequest(
    clientToken: Optional[String] = Optional.Absent,
    cloudTrailDetails: Optional[
      zio.aws.accessanalyzer.model.CloudTrailDetails
    ] = Optional.Absent,
    policyGenerationDetails: zio.aws.accessanalyzer.model.PolicyGenerationDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationRequest = {
    import StartPolicyGenerationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(cloudTrailDetails.map(value => value.buildAwsValue()))(
        _.cloudTrailDetails
      )
      .policyGenerationDetails(policyGenerationDetails.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.StartPolicyGenerationRequest.ReadOnly =
    zio.aws.accessanalyzer.model.StartPolicyGenerationRequest
      .wrap(buildAwsValue())
}
object StartPolicyGenerationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.StartPolicyGenerationRequest =
      zio.aws.accessanalyzer.model.StartPolicyGenerationRequest(
        clientToken.map(value => value),
        cloudTrailDetails.map(value => value.asEditable),
        policyGenerationDetails.asEditable
      )
    def clientToken: Optional[String]
    def cloudTrailDetails
        : Optional[zio.aws.accessanalyzer.model.CloudTrailDetails.ReadOnly]
    def policyGenerationDetails
        : zio.aws.accessanalyzer.model.PolicyGenerationDetails.ReadOnly
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCloudTrailDetails: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.CloudTrailDetails.ReadOnly
    ] = AwsError.unwrapOptionField("cloudTrailDetails", cloudTrailDetails)
    def getPolicyGenerationDetails: ZIO[
      Any,
      Nothing,
      zio.aws.accessanalyzer.model.PolicyGenerationDetails.ReadOnly
    ] = ZIO.succeed(policyGenerationDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationRequest
  ) extends zio.aws.accessanalyzer.model.StartPolicyGenerationRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val cloudTrailDetails
        : Optional[zio.aws.accessanalyzer.model.CloudTrailDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudTrailDetails())
        .map(value =>
          zio.aws.accessanalyzer.model.CloudTrailDetails.wrap(value)
        )
    override val policyGenerationDetails
        : zio.aws.accessanalyzer.model.PolicyGenerationDetails.ReadOnly =
      zio.aws.accessanalyzer.model.PolicyGenerationDetails
        .wrap(impl.policyGenerationDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationRequest
  ): zio.aws.accessanalyzer.model.StartPolicyGenerationRequest.ReadOnly =
    new Wrapper(impl)
}
