package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  RetiringPrincipal,
  IssuingAccount,
  GranteePrincipal
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KmsGrantConfiguration(
    constraints: Optional[zio.aws.accessanalyzer.model.KmsGrantConstraints] =
      Optional.Absent,
    granteePrincipal: GranteePrincipal,
    issuingAccount: IssuingAccount,
    operations: Iterable[zio.aws.accessanalyzer.model.KmsGrantOperation],
    retiringPrincipal: Optional[RetiringPrincipal] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration = {
    import KmsGrantConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration
      .builder()
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .granteePrincipal(
        GranteePrincipal.unwrap(granteePrincipal): java.lang.String
      )
      .issuingAccount(IssuingAccount.unwrap(issuingAccount): java.lang.String)
      .operationsWithStrings(operations.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        retiringPrincipal.map(value =>
          RetiringPrincipal.unwrap(value): java.lang.String
        )
      )(_.retiringPrincipal)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.KmsGrantConfiguration.wrap(buildAwsValue())
}
object KmsGrantConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.KmsGrantConfiguration =
      zio.aws.accessanalyzer.model.KmsGrantConfiguration(
        constraints.map(value => value.asEditable),
        granteePrincipal,
        issuingAccount,
        operations,
        retiringPrincipal.map(value => value)
      )
    def constraints
        : Optional[zio.aws.accessanalyzer.model.KmsGrantConstraints.ReadOnly]
    def granteePrincipal: GranteePrincipal
    def issuingAccount: IssuingAccount
    def operations: List[zio.aws.accessanalyzer.model.KmsGrantOperation]
    def retiringPrincipal: Optional[RetiringPrincipal]
    def getConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.KmsGrantConstraints.ReadOnly
    ] = AwsError.unwrapOptionField("constraints", constraints)
    def getGranteePrincipal: ZIO[Any, Nothing, GranteePrincipal] =
      ZIO.succeed(granteePrincipal)
    def getIssuingAccount: ZIO[Any, Nothing, IssuingAccount] =
      ZIO.succeed(issuingAccount)
    def getOperations: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.KmsGrantOperation
    ]] = ZIO.succeed(operations)
    def getRetiringPrincipal: ZIO[Any, AwsError, RetiringPrincipal] =
      AwsError.unwrapOptionField("retiringPrincipal", retiringPrincipal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration
  ) extends zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly {
    override val constraints
        : Optional[zio.aws.accessanalyzer.model.KmsGrantConstraints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraints())
        .map(value =>
          zio.aws.accessanalyzer.model.KmsGrantConstraints.wrap(value)
        )
    override val granteePrincipal: GranteePrincipal =
      zio.aws.accessanalyzer.model.primitives
        .GranteePrincipal(impl.granteePrincipal())
    override val issuingAccount: IssuingAccount =
      zio.aws.accessanalyzer.model.primitives
        .IssuingAccount(impl.issuingAccount())
    override val operations
        : List[zio.aws.accessanalyzer.model.KmsGrantOperation] = impl
      .operations()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.KmsGrantOperation.wrap(item)
      }
      .toList
    override val retiringPrincipal: Optional[RetiringPrincipal] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retiringPrincipal())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives.RetiringPrincipal(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration
  ): zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
