package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateArchiveRuleRequest(
    analyzerName: Name,
    clientToken: Optional[String] = Optional.Absent,
    filter: Map[String, zio.aws.accessanalyzer.model.Criterion],
    ruleName: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest = {
    import CreateArchiveRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .filter(
        filter
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.CreateArchiveRuleRequest.ReadOnly =
    zio.aws.accessanalyzer.model.CreateArchiveRuleRequest.wrap(buildAwsValue())
}
object CreateArchiveRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CreateArchiveRuleRequest =
      zio.aws.accessanalyzer.model.CreateArchiveRuleRequest(
        analyzerName,
        clientToken.map(value => value),
        filter.map({ case (key, value) =>
          key -> value.asEditable
        }),
        ruleName
      )
    def analyzerName: Name
    def clientToken: Optional[String]
    def filter: Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]
    def ruleName: Name
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFilter: ZIO[Any, Nothing, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = ZIO.succeed(filter)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest
  ) extends zio.aws.accessanalyzer.model.CreateArchiveRuleRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val filter
        : Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly] = impl
      .filter()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.accessanalyzer.model.Criterion.wrap(value)
      })
      .toMap
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest
  ): zio.aws.accessanalyzer.model.CreateArchiveRuleRequest.ReadOnly =
    new Wrapper(impl)
}
