package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPolicyGenerationsResponse(
    nextToken: Option[Token] = None,
    policyGenerations: Iterable[zio.aws.accessanalyzer.model.PolicyGeneration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse = {
    import ListPolicyGenerationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .policyGenerations(policyGenerations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse
      .wrap(buildAwsValue())
}
object ListPolicyGenerationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse =
      zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse(
        nextToken.map(value => value),
        policyGenerations.map { item =>
          item.asEditable
        }
      )
    def nextToken: Option[Token]
    def policyGenerations
        : List[zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPolicyGenerations: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly
    ]] = ZIO.succeed(policyGenerations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse
  ) extends zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val policyGenerations
        : List[zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly] = impl
      .policyGenerations()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.PolicyGeneration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse
  ): zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly =
    new Wrapper(impl)
}
