package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InlineArchiveRule(
    filter: Map[String, zio.aws.accessanalyzer.model.Criterion],
    ruleName: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule = {
    import InlineArchiveRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule
      .builder()
      .filter(
        filter
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.InlineArchiveRule.ReadOnly =
    zio.aws.accessanalyzer.model.InlineArchiveRule.wrap(buildAwsValue())
}
object InlineArchiveRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.InlineArchiveRule =
      zio.aws.accessanalyzer.model.InlineArchiveRule(
        filter.map({ case (key, value) =>
          key -> value.asEditable
        }),
        ruleName
      )
    def filter: Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]
    def ruleName: Name
    def getFilter: ZIO[Any, Nothing, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = ZIO.succeed(filter)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule
  ) extends zio.aws.accessanalyzer.model.InlineArchiveRule.ReadOnly {
    override val filter
        : Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly] = impl
      .filter()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.accessanalyzer.model.Criterion.wrap(value)
      })
      .toMap
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule
  ): zio.aws.accessanalyzer.model.InlineArchiveRule.ReadOnly = new Wrapper(impl)
}
