package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AnalyzedResourceSummary(
    resourceArn: ResourceArn,
    resourceOwnerAccount: String,
    resourceType: zio.aws.accessanalyzer.model.ResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResourceSummary = {
    import AnalyzedResourceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResourceSummary
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .resourceOwnerAccount(resourceOwnerAccount: java.lang.String)
      .resourceType(resourceType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly =
    zio.aws.accessanalyzer.model.AnalyzedResourceSummary.wrap(buildAwsValue())
}
object AnalyzedResourceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResourceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AnalyzedResourceSummary =
      zio.aws.accessanalyzer.model.AnalyzedResourceSummary(
        resourceArn,
        resourceOwnerAccount,
        resourceType
      )
    def resourceArn: ResourceArn
    def resourceOwnerAccount: String
    def resourceType: zio.aws.accessanalyzer.model.ResourceType
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getResourceOwnerAccount: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceOwnerAccount)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.ResourceType] =
      ZIO.succeed(resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResourceSummary
  ) extends zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.accessanalyzer.model.primitives.ResourceArn(impl.resourceArn())
    override val resourceOwnerAccount: String =
      impl.resourceOwnerAccount(): String
    override val resourceType: zio.aws.accessanalyzer.model.ResourceType =
      zio.aws.accessanalyzer.model.ResourceType.wrap(impl.resourceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResourceSummary
  ): zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly =
    new Wrapper(impl)
}
