package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.CloudTrailArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TrailProperties(
    allRegions: Option[Boolean] = None,
    cloudTrailArn: CloudTrailArn,
    regions: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.TrailProperties = {
    import TrailProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.TrailProperties
      .builder()
      .optionallyWith(allRegions.map(value => value: java.lang.Boolean))(
        _.allRegions
      )
      .cloudTrailArn(CloudTrailArn.unwrap(cloudTrailArn): java.lang.String)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.TrailProperties.ReadOnly =
    zio.aws.accessanalyzer.model.TrailProperties.wrap(buildAwsValue())
}
object TrailProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.TrailProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.TrailProperties =
      zio.aws.accessanalyzer.model.TrailProperties(
        allRegions.map(value => value),
        cloudTrailArn,
        regions.map(value => value)
      )
    def allRegions: Option[Boolean]
    def cloudTrailArn: CloudTrailArn
    def regions: Option[List[String]]
    def getAllRegions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allRegions", allRegions)
    def getCloudTrailArn: ZIO[Any, Nothing, CloudTrailArn] =
      ZIO.succeed(cloudTrailArn)
    def getRegions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("regions", regions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.TrailProperties
  ) extends zio.aws.accessanalyzer.model.TrailProperties.ReadOnly {
    override val allRegions: Option[Boolean] =
      scala.Option(impl.allRegions()).map(value => value: Boolean)
    override val cloudTrailArn: CloudTrailArn =
      zio.aws.accessanalyzer.model.primitives
        .CloudTrailArn(impl.cloudTrailArn())
    override val regions: Option[List[String]] = scala
      .Option(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.TrailProperties
  ): zio.aws.accessanalyzer.model.TrailProperties.ReadOnly = new Wrapper(impl)
}
