package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.AccessPointPolicy
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3AccessPointConfiguration(
    accessPointPolicy: Option[AccessPointPolicy] = None,
    networkOrigin: Option[
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration
    ] = None,
    publicAccessBlock: Option[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration = {
    import S3AccessPointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration
      .builder()
      .optionallyWith(
        accessPointPolicy.map(value =>
          AccessPointPolicy.unwrap(value): java.lang.String
        )
      )(_.accessPointPolicy)
      .optionallyWith(networkOrigin.map(value => value.buildAwsValue()))(
        _.networkOrigin
      )
      .optionallyWith(publicAccessBlock.map(value => value.buildAwsValue()))(
        _.publicAccessBlock
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.S3AccessPointConfiguration
      .wrap(buildAwsValue())
}
object S3AccessPointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.S3AccessPointConfiguration =
      zio.aws.accessanalyzer.model.S3AccessPointConfiguration(
        accessPointPolicy.map(value => value),
        networkOrigin.map(value => value.asEditable),
        publicAccessBlock.map(value => value.asEditable)
      )
    def accessPointPolicy: Option[AccessPointPolicy]
    def networkOrigin: Option[
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly
    ]
    def publicAccessBlock: Option[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ]
    def getAccessPointPolicy: ZIO[Any, AwsError, AccessPointPolicy] =
      AwsError.unwrapOptionField("accessPointPolicy", accessPointPolicy)
    def getNetworkOrigin: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkOrigin", networkOrigin)
    def getPublicAccessBlock: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("publicAccessBlock", publicAccessBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration
  ) extends zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly {
    override val accessPointPolicy: Option[AccessPointPolicy] = scala
      .Option(impl.accessPointPolicy())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives.AccessPointPolicy(value)
      )
    override val networkOrigin: Option[
      zio.aws.accessanalyzer.model.NetworkOriginConfiguration.ReadOnly
    ] = scala
      .Option(impl.networkOrigin())
      .map(value =>
        zio.aws.accessanalyzer.model.NetworkOriginConfiguration.wrap(value)
      )
    override val publicAccessBlock: Option[
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly
    ] = scala
      .Option(impl.publicAccessBlock())
      .map(value =>
        zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3AccessPointConfiguration
  ): zio.aws.accessanalyzer.model.S3AccessPointConfiguration.ReadOnly =
    new Wrapper(impl)
}
