package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  Token,
  Integer,
  AnalyzerArn,
  AccessPreviewId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAccessPreviewFindingsRequest(
    accessPreviewId: AccessPreviewId,
    analyzerArn: AnalyzerArn,
    filter: Option[Map[String, zio.aws.accessanalyzer.model.Criterion]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest = {
    import ListAccessPreviewFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
      .builder()
      .accessPreviewId(
        AccessPreviewId.unwrap(accessPreviewId): java.lang.String
      )
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.filter)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest
      .wrap(buildAwsValue())
}
object ListAccessPreviewFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest =
      zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest(
        accessPreviewId,
        analyzerArn,
        filter.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def accessPreviewId: AccessPreviewId
    def analyzerArn: AnalyzerArn
    def filter
        : Option[Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[Token]
    def getAccessPreviewId: ZIO[Any, Nothing, AccessPreviewId] =
      ZIO.succeed(accessPreviewId)
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getFilter: ZIO[Any, AwsError, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
  ) extends zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest.ReadOnly {
    override val accessPreviewId: AccessPreviewId =
      zio.aws.accessanalyzer.model.primitives
        .AccessPreviewId(impl.accessPreviewId())
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val filter
        : Option[Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]] =
      scala
        .Option(impl.filter())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.accessanalyzer.model.Criterion
                .wrap(value)
            })
            .toMap
        )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
  ): zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest.ReadOnly =
    new Wrapper(impl)
}
