package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters._
sealed trait AccessPreviewStatus {
  def unwrap
      : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus
}
object AccessPreviewStatus {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus
  ): zio.aws.accessanalyzer.model.AccessPreviewStatus = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.AccessPreviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus =
      software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETED
      extends zio.aws.accessanalyzer.model.AccessPreviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus =
      software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus.COMPLETED
  }
  case object CREATING
      extends zio.aws.accessanalyzer.model.AccessPreviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus =
      software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus.CREATING
  }
  case object FAILED extends zio.aws.accessanalyzer.model.AccessPreviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus =
      software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatus.FAILED
  }
}
