package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Criterion(
    contains: Option[Iterable[String]] = None,
    eq: Option[Iterable[String]] = None,
    exists: Option[Boolean] = None,
    neq: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Criterion = {
    import Criterion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Criterion
      .builder()
      .optionallyWith(
        contains.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.contains)
      .optionallyWith(
        eq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eq)
      .optionallyWith(exists.map(value => value: java.lang.Boolean))(_.exists)
      .optionallyWith(
        neq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.neq)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Criterion.ReadOnly =
    zio.aws.accessanalyzer.model.Criterion.wrap(buildAwsValue())
}
object Criterion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Criterion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Criterion =
      zio.aws.accessanalyzer.model.Criterion(
        contains.map(value => value),
        eq.map(value => value),
        exists.map(value => value),
        neq.map(value => value)
      )
    def contains: Option[List[String]]
    def eq: Option[List[String]]
    def exists: Option[Boolean]
    def neq: Option[List[String]]
    def getContains: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("contains", contains)
    def getEq: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eq", eq)
    def getExists: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("exists", exists)
    def getNeq: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("neq", neq)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Criterion
  ) extends zio.aws.accessanalyzer.model.Criterion.ReadOnly {
    override val contains: Option[List[String]] = scala
      .Option(impl.contains())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eq: Option[List[String]] = scala
      .Option(impl.eq())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val exists: Option[Boolean] =
      scala.Option(impl.exists()).map(value => value: Boolean)
    override val neq: Option[List[String]] = scala
      .Option(impl.neq())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Criterion
  ): zio.aws.accessanalyzer.model.Criterion.ReadOnly = new Wrapper(impl)
}
