package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3BucketAclGrantConfiguration(
    grantee: zio.aws.accessanalyzer.model.AclGrantee,
    permission: zio.aws.accessanalyzer.model.AclPermission
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration = {
    import S3BucketAclGrantConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration
      .builder()
      .grantee(grantee.buildAwsValue())
      .permission(permission.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration
      .wrap(buildAwsValue())
}
object S3BucketAclGrantConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration =
      zio.aws.accessanalyzer.model
        .S3BucketAclGrantConfiguration(grantee.asEditable, permission)
    def grantee: zio.aws.accessanalyzer.model.AclGrantee.ReadOnly
    def permission: zio.aws.accessanalyzer.model.AclPermission
    def getGrantee
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.AclGrantee.ReadOnly] =
      ZIO.succeed(grantee)
    def getPermission
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.AclPermission] =
      ZIO.succeed(permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration
  ) extends zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly {
    override val grantee: zio.aws.accessanalyzer.model.AclGrantee.ReadOnly =
      zio.aws.accessanalyzer.model.AclGrantee.wrap(impl.grantee())
    override val permission: zio.aws.accessanalyzer.model.AclPermission =
      zio.aws.accessanalyzer.model.AclPermission.wrap(impl.permission())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration
  ): zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly =
    new Wrapper(impl)
}
