package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Timestamp, RoleArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CloudTrailDetails(
    accessRole: RoleArn,
    endTime: Option[Timestamp] = None,
    startTime: Timestamp,
    trails: Iterable[zio.aws.accessanalyzer.model.Trail]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails = {
    import CloudTrailDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails
      .builder()
      .accessRole(RoleArn.unwrap(accessRole): java.lang.String)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .startTime(Timestamp.unwrap(startTime): Instant)
      .trails(trails.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.CloudTrailDetails.ReadOnly =
    zio.aws.accessanalyzer.model.CloudTrailDetails.wrap(buildAwsValue())
}
object CloudTrailDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CloudTrailDetails =
      zio.aws.accessanalyzer.model.CloudTrailDetails(
        accessRole,
        endTime.map(value => value),
        startTime,
        trails.map { item =>
          item.asEditable
        }
      )
    def accessRole: RoleArn
    def endTime: Option[Timestamp]
    def startTime: Timestamp
    def trails: List[zio.aws.accessanalyzer.model.Trail.ReadOnly]
    def getAccessRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(accessRole)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getTrails
        : ZIO[Any, Nothing, List[zio.aws.accessanalyzer.model.Trail.ReadOnly]] =
      ZIO.succeed(trails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails
  ) extends zio.aws.accessanalyzer.model.CloudTrailDetails.ReadOnly {
    override val accessRole: RoleArn =
      zio.aws.accessanalyzer.model.primitives.RoleArn(impl.accessRole())
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.accessanalyzer.model.primitives.Timestamp(value))
    override val startTime: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.startTime())
    override val trails: List[zio.aws.accessanalyzer.model.Trail.ReadOnly] =
      impl
        .trails()
        .asScala
        .map { item =>
          zio.aws.accessanalyzer.model.Trail.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CloudTrailDetails
  ): zio.aws.accessanalyzer.model.CloudTrailDetails.ReadOnly = new Wrapper(impl)
}
