package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AccessPreviewStatusReason(
    code: zio.aws.accessanalyzer.model.AccessPreviewStatusReasonCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReason = {
    import AccessPreviewStatusReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReason
      .builder()
      .code(code.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.AccessPreviewStatusReason.ReadOnly =
    zio.aws.accessanalyzer.model.AccessPreviewStatusReason.wrap(buildAwsValue())
}
object AccessPreviewStatusReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AccessPreviewStatusReason =
      zio.aws.accessanalyzer.model.AccessPreviewStatusReason(code)
    def code: zio.aws.accessanalyzer.model.AccessPreviewStatusReasonCode
    def getCode: ZIO[
      Any,
      Nothing,
      zio.aws.accessanalyzer.model.AccessPreviewStatusReasonCode
    ] = ZIO.succeed(code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReason
  ) extends zio.aws.accessanalyzer.model.AccessPreviewStatusReason.ReadOnly {
    override val code
        : zio.aws.accessanalyzer.model.AccessPreviewStatusReasonCode =
      zio.aws.accessanalyzer.model.AccessPreviewStatusReasonCode
        .wrap(impl.code())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReason
  ): zio.aws.accessanalyzer.model.AccessPreviewStatusReason.ReadOnly =
    new Wrapper(impl)
}
