package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAccessPreviewsResponse(
    accessPreviews: Iterable[zio.aws.accessanalyzer.model.AccessPreviewSummary],
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse = {
    import ListAccessPreviewsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse
      .builder()
      .accessPreviews(accessPreviews.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListAccessPreviewsResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ListAccessPreviewsResponse
      .wrap(buildAwsValue())
}
object ListAccessPreviewsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListAccessPreviewsResponse =
      zio.aws.accessanalyzer.model.ListAccessPreviewsResponse(
        accessPreviews.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def accessPreviews
        : List[zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly]
    def nextToken: Option[Token]
    def getAccessPreviews: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly
    ]] = ZIO.succeed(accessPreviews)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse
  ) extends zio.aws.accessanalyzer.model.ListAccessPreviewsResponse.ReadOnly {
    override val accessPreviews
        : List[zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly] =
      impl
        .accessPreviews()
        .asScala
        .map { item =>
          zio.aws.accessanalyzer.model.AccessPreviewSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsResponse
  ): zio.aws.accessanalyzer.model.ListAccessPreviewsResponse.ReadOnly =
    new Wrapper(impl)
}
