package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Token, Integer, AnalyzerArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAnalyzedResourcesRequest(
    analyzerArn: AnalyzerArn,
    maxResults: Option[Integer] = None,
    nextToken: Option[Token] = None,
    resourceType: Option[zio.aws.accessanalyzer.model.ResourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest = {
    import ListAnalyzedResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest
      .wrap(buildAwsValue())
}
object ListAnalyzedResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest =
      zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest(
        analyzerArn,
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceType.map(value => value)
      )
    def analyzerArn: AnalyzerArn
    def maxResults: Option[Integer]
    def nextToken: Option[Token]
    def resourceType: Option[zio.aws.accessanalyzer.model.ResourceType]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.accessanalyzer.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest
  ) extends zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.accessanalyzer.model.primitives.Integer(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val resourceType
        : Option[zio.aws.accessanalyzer.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.accessanalyzer.model.ResourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest
  ): zio.aws.accessanalyzer.model.ListAnalyzedResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
