package zio.aws.accessanalyzer
import zio.aws.accessanalyzer.model.FindingSummary.ReadOnly
import zio.aws.accessanalyzer.model.{
  GetAnalyzedResourceRequest,
  ApplyArchiveRuleRequest,
  ListAnalyzedResourcesRequest,
  ListAccessPreviewsRequest,
  ValidatePolicyRequest,
  CreateAnalyzerRequest,
  ListPolicyGenerationsRequest,
  StartResourceScanRequest,
  ListAnalyzersRequest,
  GetFindingRequest,
  ListTagsForResourceRequest,
  GetArchiveRuleRequest,
  UpdateArchiveRuleRequest,
  GetGeneratedPolicyRequest,
  ListFindingsRequest,
  ListAccessPreviewFindingsRequest,
  StartPolicyGenerationRequest,
  DeleteAnalyzerRequest,
  GetAccessPreviewRequest,
  GetAnalyzerRequest,
  UntagResourceRequest,
  CreateArchiveRuleRequest,
  CancelPolicyGenerationRequest,
  UpdateFindingsRequest,
  ListArchiveRulesRequest,
  TagResourceRequest,
  DeleteArchiveRuleRequest,
  CreateAccessPreviewRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.accessanalyzer.paginators.{
  ListAnalyzedResourcesPublisher,
  ListAccessPreviewFindingsPublisher,
  ListAnalyzersPublisher,
  ListFindingsPublisher,
  ValidatePolicyPublisher,
  ListPolicyGenerationsPublisher,
  ListArchiveRulesPublisher,
  ListAccessPreviewsPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.accessanalyzer.model.{
  GetArchiveRuleResponse,
  CancelPolicyGenerationResponse,
  AccessPreviewFinding,
  AnalyzerSummary,
  GetAccessPreviewResponse,
  AccessPreviewSummary,
  ListArchiveRulesResponse,
  ListAnalyzersResponse,
  StartResourceScanResponse,
  CreateAnalyzerResponse,
  FindingSummary,
  CreateArchiveRuleResponse,
  ValidatePolicyFinding,
  DeleteAnalyzerResponse,
  ListTagsForResourceResponse,
  ValidatePolicyResponse,
  ListFindingsResponse,
  UntagResourceResponse,
  UpdateArchiveRuleResponse,
  ApplyArchiveRuleResponse,
  GetAnalyzedResourceResponse,
  PolicyGeneration,
  ListAnalyzedResourcesResponse,
  GetFindingResponse,
  StartPolicyGenerationResponse,
  ArchiveRuleSummary,
  GetAnalyzerResponse,
  ListAccessPreviewsResponse,
  DeleteArchiveRuleResponse,
  CreateAccessPreviewResponse,
  ListAccessPreviewFindingsResponse,
  AnalyzedResourceSummary,
  ListPolicyGenerationsResponse,
  GetGeneratedPolicyResponse,
  UpdateFindingsResponse,
  TagResourceResponse
}
import software.amazon.awssdk.services.accessanalyzer.{
  AccessAnalyzerAsyncClientBuilder,
  AccessAnalyzerAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait AccessAnalyzer extends AspectSupport[AccessAnalyzer] {
  val api: AccessAnalyzerAsyncClient
  def listAnalyzedResources(request: ListAnalyzedResourcesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly
  ]
  def listAnalyzedResourcesPaginated(request: ListAnalyzedResourcesRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse.ReadOnly
  ]
  def listFindings(
      request: ListFindingsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listFindingsPaginated(
      request: ListFindingsRequest
  ): IO[AwsError, zio.aws.accessanalyzer.model.ListFindingsResponse.ReadOnly]
  def createAnalyzer(
      request: CreateAnalyzerRequest
  ): IO[AwsError, zio.aws.accessanalyzer.model.CreateAnalyzerResponse.ReadOnly]
  def deleteAnalyzer(request: DeleteAnalyzerRequest): IO[AwsError, Unit]
  def startResourceScan(request: StartResourceScanRequest): IO[AwsError, Unit]
  def cancelPolicyGeneration(request: CancelPolicyGenerationRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.CancelPolicyGenerationResponse.ReadOnly
  ]
  def updateArchiveRule(request: UpdateArchiveRuleRequest): IO[AwsError, Unit]
  def listArchiveRules(request: ListArchiveRulesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly
  ]
  def listArchiveRulesPaginated(request: ListArchiveRulesRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.ListArchiveRulesResponse.ReadOnly
  ]
  def getArchiveRule(
      request: GetArchiveRuleRequest
  ): IO[AwsError, zio.aws.accessanalyzer.model.GetArchiveRuleResponse.ReadOnly]
  def getAnalyzedResource(request: GetAnalyzedResourceRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse.ReadOnly
  ]
  def getGeneratedPolicy(request: GetGeneratedPolicyRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly
  ]
  def getFinding(
      request: GetFindingRequest
  ): IO[AwsError, zio.aws.accessanalyzer.model.GetFindingResponse.ReadOnly]
  def createAccessPreview(request: CreateAccessPreviewRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.CreateAccessPreviewResponse.ReadOnly
  ]
  def startPolicyGeneration(request: StartPolicyGenerationRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.StartPolicyGenerationResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.accessanalyzer.model.UntagResourceResponse.ReadOnly]
  def updateFindings(request: UpdateFindingsRequest): IO[AwsError, Unit]
  def getAccessPreview(request: GetAccessPreviewRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.GetAccessPreviewResponse.ReadOnly
  ]
  def listAccessPreviewFindings(
      request: ListAccessPreviewFindingsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly
  ]
  def listAccessPreviewFindingsPaginated(
      request: ListAccessPreviewFindingsRequest
  ): IO[
    AwsError,
    zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse.ReadOnly
  ]
  def applyArchiveRule(request: ApplyArchiveRuleRequest): IO[AwsError, Unit]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.accessanalyzer.model.TagResourceResponse.ReadOnly]
  def deleteArchiveRule(request: DeleteArchiveRuleRequest): IO[AwsError, Unit]
  def listAccessPreviews(request: ListAccessPreviewsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly
  ]
  def listAccessPreviewsPaginated(request: ListAccessPreviewsRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.ListAccessPreviewsResponse.ReadOnly
  ]
  def getAnalyzer(
      request: GetAnalyzerRequest
  ): IO[AwsError, zio.aws.accessanalyzer.model.GetAnalyzerResponse.ReadOnly]
  def listAnalyzers(request: ListAnalyzersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly
  ]
  def listAnalyzersPaginated(
      request: ListAnalyzersRequest
  ): IO[AwsError, zio.aws.accessanalyzer.model.ListAnalyzersResponse.ReadOnly]
  def validatePolicy(request: ValidatePolicyRequest): ZStream[
    Any,
    AwsError,
    zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly
  ]
  def validatePolicyPaginated(
      request: ValidatePolicyRequest
  ): IO[AwsError, zio.aws.accessanalyzer.model.ValidatePolicyResponse.ReadOnly]
  def createArchiveRule(request: CreateArchiveRuleRequest): IO[AwsError, Unit]
  def listPolicyGenerations(request: ListPolicyGenerationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly
  ]
  def listPolicyGenerationsPaginated(request: ListPolicyGenerationsRequest): IO[
    AwsError,
    zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly
  ]
}
object AccessAnalyzer {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AccessAnalyzer] = customized(
    identity
  )
  def customized(
      customization: AccessAnalyzerAsyncClientBuilder => AccessAnalyzerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AccessAnalyzer] = managed(
    customization
  ).toLayer
  def managed(
      customization: AccessAnalyzerAsyncClientBuilder => AccessAnalyzerAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, AccessAnalyzer] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AccessAnalyzerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AccessAnalyzerAsyncClient, AccessAnalyzerAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        AccessAnalyzerAsyncClient,
        AccessAnalyzerAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new AccessAnalyzerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AccessAnalyzerImpl[R](
      override val api: AccessAnalyzerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AccessAnalyzer
      with AwsServiceBase[R] {
    override val serviceName: String = "AccessAnalyzer"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AccessAnalyzerImpl[R1] = new AccessAnalyzerImpl(api, newAspect, r)
    def listAnalyzedResources(request: ListAnalyzedResourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest,
      AnalyzedResourceSummary,
      ListAnalyzedResourcesPublisher
    ](
      "listAnalyzedResources",
      api.listAnalyzedResourcesPaginator,
      _.analyzedResources()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.accessanalyzer.model.AnalyzedResourceSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listAnalyzedResourcesPaginated(
        request: ListAnalyzedResourcesRequest
    ): IO[
      AwsError,
      zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest,
      ListAnalyzedResourcesResponse
    ]("listAnalyzedResources", api.listAnalyzedResources)(
      request.buildAwsValue()
    ).map(zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse.wrap)
      .provideEnvironment(r)
    def listFindings(
        request: ListFindingsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest,
      FindingSummary,
      ListFindingsPublisher
    ]("listFindings", api.listFindingsPaginator, _.findings())(
      request.buildAwsValue()
    ).map(item => zio.aws.accessanalyzer.model.FindingSummary.wrap(item))
      .provideEnvironment(r)
    def listFindingsPaginated(request: ListFindingsRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.ListFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest,
      ListFindingsResponse
    ]("listFindings", api.listFindings)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.ListFindingsResponse.wrap)
      .provideEnvironment(r)
    def createAnalyzer(request: CreateAnalyzerRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.CreateAnalyzerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest,
      CreateAnalyzerResponse
    ]("createAnalyzer", api.createAnalyzer)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.CreateAnalyzerResponse.wrap)
      .provideEnvironment(r)
    def deleteAnalyzer(request: DeleteAnalyzerRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest,
        DeleteAnalyzerResponse
      ]("deleteAnalyzer", api.deleteAnalyzer)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def startResourceScan(
        request: StartResourceScanRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest,
      StartResourceScanResponse
    ]("startResourceScan", api.startResourceScan)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def cancelPolicyGeneration(request: CancelPolicyGenerationRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.CancelPolicyGenerationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.CancelPolicyGenerationRequest,
      CancelPolicyGenerationResponse
    ]("cancelPolicyGeneration", api.cancelPolicyGeneration)(
      request.buildAwsValue()
    ).map(zio.aws.accessanalyzer.model.CancelPolicyGenerationResponse.wrap)
      .provideEnvironment(r)
    def updateArchiveRule(
        request: UpdateArchiveRuleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest,
      UpdateArchiveRuleResponse
    ]("updateArchiveRule", api.updateArchiveRule)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listArchiveRules(request: ListArchiveRulesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest,
      ArchiveRuleSummary,
      ListArchiveRulesPublisher
    ]("listArchiveRules", api.listArchiveRulesPaginator, _.archiveRules())(
      request.buildAwsValue()
    ).map(item => zio.aws.accessanalyzer.model.ArchiveRuleSummary.wrap(item))
      .provideEnvironment(r)
    def listArchiveRulesPaginated(request: ListArchiveRulesRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.ListArchiveRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest,
      ListArchiveRulesResponse
    ]("listArchiveRules", api.listArchiveRules)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.ListArchiveRulesResponse.wrap)
      .provideEnvironment(r)
    def getArchiveRule(request: GetArchiveRuleRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.GetArchiveRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest,
      GetArchiveRuleResponse
    ]("getArchiveRule", api.getArchiveRule)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.GetArchiveRuleResponse.wrap)
      .provideEnvironment(r)
    def getAnalyzedResource(request: GetAnalyzedResourceRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest,
      GetAnalyzedResourceResponse
    ]("getAnalyzedResource", api.getAnalyzedResource)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse.wrap)
      .provideEnvironment(r)
    def getGeneratedPolicy(request: GetGeneratedPolicyRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.GetGeneratedPolicyRequest,
      GetGeneratedPolicyResponse
    ]("getGeneratedPolicy", api.getGeneratedPolicy)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.wrap)
      .provideEnvironment(r)
    def getFinding(
        request: GetFindingRequest
    ): IO[AwsError, zio.aws.accessanalyzer.model.GetFindingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest,
        GetFindingResponse
      ]("getFinding", api.getFinding)(request.buildAwsValue())
        .map(zio.aws.accessanalyzer.model.GetFindingResponse.wrap)
        .provideEnvironment(r)
    def createAccessPreview(request: CreateAccessPreviewRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.CreateAccessPreviewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.CreateAccessPreviewRequest,
      CreateAccessPreviewResponse
    ]("createAccessPreview", api.createAccessPreview)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.CreateAccessPreviewResponse.wrap)
      .provideEnvironment(r)
    def startPolicyGeneration(request: StartPolicyGenerationRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.StartPolicyGenerationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.StartPolicyGenerationRequest,
      StartPolicyGenerationResponse
    ]("startPolicyGeneration", api.startPolicyGeneration)(
      request.buildAwsValue()
    ).map(zio.aws.accessanalyzer.model.StartPolicyGenerationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def updateFindings(request: UpdateFindingsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest,
        UpdateFindingsResponse
      ]("updateFindings", api.updateFindings)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getAccessPreview(request: GetAccessPreviewRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.GetAccessPreviewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.GetAccessPreviewRequest,
      GetAccessPreviewResponse
    ]("getAccessPreview", api.getAccessPreview)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.GetAccessPreviewResponse.wrap)
      .provideEnvironment(r)
    def listAccessPreviewFindings(
        request: ListAccessPreviewFindingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest,
      AccessPreviewFinding,
      ListAccessPreviewFindingsPublisher
    ](
      "listAccessPreviewFindings",
      api.listAccessPreviewFindingsPaginator,
      _.findings()
    )(request.buildAwsValue())
      .map(item => zio.aws.accessanalyzer.model.AccessPreviewFinding.wrap(item))
      .provideEnvironment(r)
    def listAccessPreviewFindingsPaginated(
        request: ListAccessPreviewFindingsRequest
    ): IO[
      AwsError,
      zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest,
      ListAccessPreviewFindingsResponse
    ]("listAccessPreviewFindings", api.listAccessPreviewFindings)(
      request.buildAwsValue()
    ).map(zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse.wrap)
      .provideEnvironment(r)
    def applyArchiveRule(request: ApplyArchiveRuleRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest,
        ApplyArchiveRuleResponse
      ]("applyArchiveRule", api.applyArchiveRule)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.accessanalyzer.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.accessanalyzer.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteArchiveRule(
        request: DeleteArchiveRuleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest,
      DeleteArchiveRuleResponse
    ]("deleteArchiveRule", api.deleteArchiveRule)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listAccessPreviews(request: ListAccessPreviewsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest,
      AccessPreviewSummary,
      ListAccessPreviewsPublisher
    ](
      "listAccessPreviews",
      api.listAccessPreviewsPaginator,
      _.accessPreviews()
    )(request.buildAwsValue())
      .map(item => zio.aws.accessanalyzer.model.AccessPreviewSummary.wrap(item))
      .provideEnvironment(r)
    def listAccessPreviewsPaginated(request: ListAccessPreviewsRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.ListAccessPreviewsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest,
      ListAccessPreviewsResponse
    ]("listAccessPreviews", api.listAccessPreviews)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.ListAccessPreviewsResponse.wrap)
      .provideEnvironment(r)
    def getAnalyzer(
        request: GetAnalyzerRequest
    ): IO[AwsError, zio.aws.accessanalyzer.model.GetAnalyzerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest,
        GetAnalyzerResponse
      ]("getAnalyzer", api.getAnalyzer)(request.buildAwsValue())
        .map(zio.aws.accessanalyzer.model.GetAnalyzerResponse.wrap)
        .provideEnvironment(r)
    def listAnalyzers(request: ListAnalyzersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest,
      AnalyzerSummary,
      ListAnalyzersPublisher
    ]("listAnalyzers", api.listAnalyzersPaginator, _.analyzers())(
      request.buildAwsValue()
    ).map(item => zio.aws.accessanalyzer.model.AnalyzerSummary.wrap(item))
      .provideEnvironment(r)
    def listAnalyzersPaginated(request: ListAnalyzersRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.ListAnalyzersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest,
      ListAnalyzersResponse
    ]("listAnalyzers", api.listAnalyzers)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.ListAnalyzersResponse.wrap)
      .provideEnvironment(r)
    def validatePolicy(request: ValidatePolicyRequest): ZStream[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest,
      ValidatePolicyFinding,
      ValidatePolicyPublisher
    ]("validatePolicy", api.validatePolicyPaginator, _.findings())(
      request.buildAwsValue()
    ).map(item => zio.aws.accessanalyzer.model.ValidatePolicyFinding.wrap(item))
      .provideEnvironment(r)
    def validatePolicyPaginated(request: ValidatePolicyRequest): IO[
      AwsError,
      zio.aws.accessanalyzer.model.ValidatePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest,
      ValidatePolicyResponse
    ]("validatePolicy", api.validatePolicy)(request.buildAwsValue())
      .map(zio.aws.accessanalyzer.model.ValidatePolicyResponse.wrap)
      .provideEnvironment(r)
    def createArchiveRule(
        request: CreateArchiveRuleRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest,
      CreateArchiveRuleResponse
    ]("createArchiveRule", api.createArchiveRule)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def listPolicyGenerations(request: ListPolicyGenerationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest,
      PolicyGeneration,
      ListPolicyGenerationsPublisher
    ](
      "listPolicyGenerations",
      api.listPolicyGenerationsPaginator,
      _.policyGenerations()
    )(request.buildAwsValue())
      .map(item => zio.aws.accessanalyzer.model.PolicyGeneration.wrap(item))
      .provideEnvironment(r)
    def listPolicyGenerationsPaginated(
        request: ListPolicyGenerationsRequest
    ): IO[
      AwsError,
      zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest,
      ListPolicyGenerationsResponse
    ]("listPolicyGenerations", api.listPolicyGenerations)(
      request.buildAwsValue()
    ).map(zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.wrap)
      .provideEnvironment(r)
  }
  def listAnalyzedResources(request: ListAnalyzedResourcesRequest): ZStream[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAnalyzedResources(request))
  def listAnalyzedResourcesPaginated(
      request: ListAnalyzedResourcesRequest
  ): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAnalyzedResourcesPaginated(request))
  def listFindings(
      request: ListFindingsRequest
  ): ZStream[zio.aws.accessanalyzer.AccessAnalyzer, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listFindings(request))
  def listFindingsPaginated(request: ListFindingsRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ListFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindingsPaginated(request))
  def createAnalyzer(request: CreateAnalyzerRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.CreateAnalyzerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAnalyzer(request))
  def deleteAnalyzer(
      request: DeleteAnalyzerRequest
  ): ZIO[zio.aws.accessanalyzer.AccessAnalyzer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAnalyzer(request))
  def startResourceScan(
      request: StartResourceScanRequest
  ): ZIO[zio.aws.accessanalyzer.AccessAnalyzer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startResourceScan(request))
  def cancelPolicyGeneration(request: CancelPolicyGenerationRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.CancelPolicyGenerationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelPolicyGeneration(request))
  def updateArchiveRule(
      request: UpdateArchiveRuleRequest
  ): ZIO[zio.aws.accessanalyzer.AccessAnalyzer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateArchiveRule(request))
  def listArchiveRules(request: ListArchiveRulesRequest): ZStream[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listArchiveRules(request))
  def listArchiveRulesPaginated(request: ListArchiveRulesRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ListArchiveRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listArchiveRulesPaginated(request))
  def getArchiveRule(request: GetArchiveRuleRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.GetArchiveRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getArchiveRule(request))
  def getAnalyzedResource(request: GetAnalyzedResourceRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAnalyzedResource(request))
  def getGeneratedPolicy(request: GetGeneratedPolicyRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.GetGeneratedPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGeneratedPolicy(request))
  def getFinding(request: GetFindingRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.GetFindingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFinding(request))
  def createAccessPreview(request: CreateAccessPreviewRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.CreateAccessPreviewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccessPreview(request))
  def startPolicyGeneration(request: StartPolicyGenerationRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.StartPolicyGenerationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startPolicyGeneration(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def updateFindings(
      request: UpdateFindingsRequest
  ): ZIO[zio.aws.accessanalyzer.AccessAnalyzer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateFindings(request))
  def getAccessPreview(request: GetAccessPreviewRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.GetAccessPreviewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccessPreview(request))
  def listAccessPreviewFindings(
      request: ListAccessPreviewFindingsRequest
  ): ZStream[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccessPreviewFindings(request))
  def listAccessPreviewFindingsPaginated(
      request: ListAccessPreviewFindingsRequest
  ): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ListAccessPreviewFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessPreviewFindingsPaginated(request))
  def applyArchiveRule(
      request: ApplyArchiveRuleRequest
  ): ZIO[zio.aws.accessanalyzer.AccessAnalyzer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.applyArchiveRule(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteArchiveRule(
      request: DeleteArchiveRuleRequest
  ): ZIO[zio.aws.accessanalyzer.AccessAnalyzer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteArchiveRule(request))
  def listAccessPreviews(request: ListAccessPreviewsRequest): ZStream[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccessPreviews(request))
  def listAccessPreviewsPaginated(request: ListAccessPreviewsRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ListAccessPreviewsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessPreviewsPaginated(request))
  def getAnalyzer(request: GetAnalyzerRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.GetAnalyzerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAnalyzer(request))
  def listAnalyzers(request: ListAnalyzersRequest): ZStream[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAnalyzers(request))
  def listAnalyzersPaginated(request: ListAnalyzersRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ListAnalyzersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAnalyzersPaginated(request))
  def validatePolicy(request: ValidatePolicyRequest): ZStream[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly
  ] = ZStream.serviceWithStream(_.validatePolicy(request))
  def validatePolicyPaginated(request: ValidatePolicyRequest): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ValidatePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validatePolicyPaginated(request))
  def createArchiveRule(
      request: CreateArchiveRuleRequest
  ): ZIO[zio.aws.accessanalyzer.AccessAnalyzer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createArchiveRule(request))
  def listPolicyGenerations(request: ListPolicyGenerationsRequest): ZStream[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly
  ] = ZStream.serviceWithStream(_.listPolicyGenerations(request))
  def listPolicyGenerationsPaginated(
      request: ListPolicyGenerationsRequest
  ): ZIO[
    zio.aws.accessanalyzer.AccessAnalyzer,
    AwsError,
    zio.aws.accessanalyzer.model.ListPolicyGenerationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPolicyGenerationsPaginated(request))
}
