package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{JobId, Timestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class JobDetails(
    completedOn: Option[Timestamp] = None,
    jobError: Option[zio.aws.accessanalyzer.model.JobError] = None,
    jobId: JobId,
    startedOn: Timestamp,
    status: zio.aws.accessanalyzer.model.JobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.JobDetails = {
    import JobDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.JobDetails
      .builder()
      .optionallyWith(
        completedOn.map(value => Timestamp.unwrap(value): Instant)
      )(_.completedOn)
      .optionallyWith(jobError.map(value => value.buildAwsValue()))(_.jobError)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .startedOn(Timestamp.unwrap(startedOn): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.JobDetails.ReadOnly =
    zio.aws.accessanalyzer.model.JobDetails.wrap(buildAwsValue())
}
object JobDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.JobDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.JobDetails =
      zio.aws.accessanalyzer.model.JobDetails(
        completedOn.map(value => value),
        jobError.map(value => value.asEditable),
        jobId,
        startedOn,
        status
      )
    def completedOn: Option[Timestamp]
    def jobError: Option[zio.aws.accessanalyzer.model.JobError.ReadOnly]
    def jobId: JobId
    def startedOn: Timestamp
    def status: zio.aws.accessanalyzer.model.JobStatus
    def getCompletedOn: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completedOn", completedOn)
    def getJobError
        : ZIO[Any, AwsError, zio.aws.accessanalyzer.model.JobError.ReadOnly] =
      AwsError.unwrapOptionField("jobError", jobError)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStartedOn: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startedOn)
    def getStatus: ZIO[Any, Nothing, zio.aws.accessanalyzer.model.JobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.JobDetails
  ) extends zio.aws.accessanalyzer.model.JobDetails.ReadOnly {
    override val completedOn: Option[Timestamp] = scala
      .Option(impl.completedOn())
      .map(value => zio.aws.accessanalyzer.model.primitives.Timestamp(value))
    override val jobError
        : Option[zio.aws.accessanalyzer.model.JobError.ReadOnly] = scala
      .Option(impl.jobError())
      .map(value => zio.aws.accessanalyzer.model.JobError.wrap(value))
    override val jobId: JobId =
      zio.aws.accessanalyzer.model.primitives.JobId(impl.jobId())
    override val startedOn: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.startedOn())
    override val status: zio.aws.accessanalyzer.model.JobStatus =
      zio.aws.accessanalyzer.model.JobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.JobDetails
  ): zio.aws.accessanalyzer.model.JobDetails.ReadOnly = new Wrapper(impl)
}
