package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobError(
    code: zio.aws.accessanalyzer.model.JobErrorCode,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.JobError = {
    import JobError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.JobError
      .builder()
      .code(code.unwrap)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.JobError.ReadOnly =
    zio.aws.accessanalyzer.model.JobError.wrap(buildAwsValue())
}
object JobError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.JobError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.JobError =
      zio.aws.accessanalyzer.model.JobError(code, message)
    def code: zio.aws.accessanalyzer.model.JobErrorCode
    def message: String
    def getCode: ZIO[Any, Nothing, zio.aws.accessanalyzer.model.JobErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, Nothing, String] = ZIO.succeed(message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.JobError
  ) extends zio.aws.accessanalyzer.model.JobError.ReadOnly {
    override val code: zio.aws.accessanalyzer.model.JobErrorCode =
      zio.aws.accessanalyzer.model.JobErrorCode.wrap(impl.code())
    override val message: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.JobError
  ): zio.aws.accessanalyzer.model.JobError.ReadOnly = new Wrapper(impl)
}
