package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  SecretsManagerSecretPolicy,
  SecretsManagerSecretKmsId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SecretsManagerSecretConfiguration(
    kmsKeyId: Option[SecretsManagerSecretKmsId] = None,
    secretPolicy: Option[SecretsManagerSecretPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.SecretsManagerSecretConfiguration = {
    import SecretsManagerSecretConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.SecretsManagerSecretConfiguration
      .builder()
      .optionallyWith(
        kmsKeyId.map(value =>
          SecretsManagerSecretKmsId.unwrap(value): java.lang.String
        )
      )(_.kmsKeyId)
      .optionallyWith(
        secretPolicy.map(value =>
          SecretsManagerSecretPolicy.unwrap(value): java.lang.String
        )
      )(_.secretPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration
      .wrap(buildAwsValue())
}
object SecretsManagerSecretConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.SecretsManagerSecretConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration =
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration(
        kmsKeyId.map(value => value),
        secretPolicy.map(value => value)
      )
    def kmsKeyId: Option[SecretsManagerSecretKmsId]
    def secretPolicy: Option[SecretsManagerSecretPolicy]
    def getKmsKeyId: ZIO[Any, AwsError, SecretsManagerSecretKmsId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSecretPolicy: ZIO[Any, AwsError, SecretsManagerSecretPolicy] =
      AwsError.unwrapOptionField("secretPolicy", secretPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.SecretsManagerSecretConfiguration
  ) extends zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly {
    override val kmsKeyId: Option[SecretsManagerSecretKmsId] = scala
      .Option(impl.kmsKeyId())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives.SecretsManagerSecretKmsId(value)
      )
    override val secretPolicy: Option[SecretsManagerSecretPolicy] = scala
      .Option(impl.secretPolicy())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives
          .SecretsManagerSecretPolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.SecretsManagerSecretConfiguration
  ): zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly =
    new Wrapper(impl)
}
