package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CloudTrailProperties(
    endTime: Timestamp,
    startTime: Timestamp,
    trailProperties: Iterable[zio.aws.accessanalyzer.model.TrailProperties]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties = {
    import CloudTrailProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties
      .builder()
      .endTime(Timestamp.unwrap(endTime): Instant)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .trailProperties(trailProperties.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.CloudTrailProperties.ReadOnly =
    zio.aws.accessanalyzer.model.CloudTrailProperties.wrap(buildAwsValue())
}
object CloudTrailProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CloudTrailProperties =
      zio.aws.accessanalyzer.model.CloudTrailProperties(
        endTime,
        startTime,
        trailProperties.map { item =>
          item.asEditable
        }
      )
    def endTime: Timestamp
    def startTime: Timestamp
    def trailProperties
        : List[zio.aws.accessanalyzer.model.TrailProperties.ReadOnly]
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getTrailProperties: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.TrailProperties.ReadOnly
    ]] = ZIO.succeed(trailProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties
  ) extends zio.aws.accessanalyzer.model.CloudTrailProperties.ReadOnly {
    override val endTime: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.endTime())
    override val startTime: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.startTime())
    override val trailProperties
        : List[zio.aws.accessanalyzer.model.TrailProperties.ReadOnly] = impl
      .trailProperties()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.TrailProperties.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties
  ): zio.aws.accessanalyzer.model.CloudTrailProperties.ReadOnly = new Wrapper(
    impl
  )
}
