package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{PolicyDocument, Token, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ValidatePolicyRequest(
    locale: Option[zio.aws.accessanalyzer.model.Locale] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[Token] = None,
    policyDocument: PolicyDocument,
    policyType: zio.aws.accessanalyzer.model.PolicyType,
    validatePolicyResourceType: Option[
      zio.aws.accessanalyzer.model.ValidatePolicyResourceType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest = {
    import ValidatePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest
      .builder()
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .policyDocument(PolicyDocument.unwrap(policyDocument): java.lang.String)
      .policyType(policyType.unwrap)
      .optionallyWith(validatePolicyResourceType.map(value => value.unwrap))(
        _.validatePolicyResourceType
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ValidatePolicyRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ValidatePolicyRequest.wrap(buildAwsValue())
}
object ValidatePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ValidatePolicyRequest =
      zio.aws.accessanalyzer.model.ValidatePolicyRequest(
        locale.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        policyDocument,
        policyType,
        validatePolicyResourceType.map(value => value)
      )
    def locale: Option[zio.aws.accessanalyzer.model.Locale]
    def maxResults: Option[Integer]
    def nextToken: Option[Token]
    def policyDocument: PolicyDocument
    def policyType: zio.aws.accessanalyzer.model.PolicyType
    def validatePolicyResourceType
        : Option[zio.aws.accessanalyzer.model.ValidatePolicyResourceType]
    def getLocale: ZIO[Any, AwsError, zio.aws.accessanalyzer.model.Locale] =
      AwsError.unwrapOptionField("locale", locale)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocument] =
      ZIO.succeed(policyDocument)
    def getPolicyType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.PolicyType] =
      ZIO.succeed(policyType)
    def getValidatePolicyResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.ValidatePolicyResourceType
    ] = AwsError.unwrapOptionField(
      "validatePolicyResourceType",
      validatePolicyResourceType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest
  ) extends zio.aws.accessanalyzer.model.ValidatePolicyRequest.ReadOnly {
    override val locale: Option[zio.aws.accessanalyzer.model.Locale] = scala
      .Option(impl.locale())
      .map(value => zio.aws.accessanalyzer.model.Locale.wrap(value))
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.accessanalyzer.model.primitives.Integer(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val policyDocument: PolicyDocument =
      zio.aws.accessanalyzer.model.primitives
        .PolicyDocument(impl.policyDocument())
    override val policyType: zio.aws.accessanalyzer.model.PolicyType =
      zio.aws.accessanalyzer.model.PolicyType.wrap(impl.policyType())
    override val validatePolicyResourceType
        : Option[zio.aws.accessanalyzer.model.ValidatePolicyResourceType] =
      scala
        .Option(impl.validatePolicyResourceType())
        .map(value =>
          zio.aws.accessanalyzer.model.ValidatePolicyResourceType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest
  ): zio.aws.accessanalyzer.model.ValidatePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
