/*
 * Decompiled with CFR 0.152.
 */
package zio.cli.examples;

import izumi.reflect.Tag;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import zio.Chunk;
import zio.Console$;
import zio.ExitCode;
import zio.NonEmptyChunk;
import zio.NonEmptyChunk$;
import zio.Runtime;
import zio.ZIO;
import zio.ZIOApp;
import zio.ZIOAppArgs;
import zio.ZIOAppDefault;
import zio.ZIOAppPlatformSpecific;
import zio.ZIOAppVersionSpecific;
import zio.ZLayer;
import zio.Zippable$;
import zio.cli.Args;
import zio.cli.Args$;
import zio.cli.CliApp;
import zio.cli.CliApp$;
import zio.cli.CliConfig;
import zio.cli.Command;
import zio.cli.Command$;
import zio.cli.HelpDoc;
import zio.cli.HelpDoc$;
import zio.cli.Options;
import zio.cli.Options$;
import zio.cli.Reducable$;
import zio.cli.ZIOCli;
import zio.cli.ZIOCliDefault;
import zio.cli.examples.StringUtil;
import zio.cli.figlet.FigFont;

public final class StringUtil$
implements ZIOCliDefault {
    public static final StringUtil$ MODULE$ = new StringUtil$();
    private static final Options<Object> firstOption;
    private static final Options<String> separatorOption;
    private static final Args<String> stringArg;
    private static final Command<StringUtil.Subcommand.Split> split;
    private static final Command<StringUtil.Subcommand.Join> join;
    private static final Command<StringUtil.Subcommand> stringUtil;
    private static final CliApp<ZIOAppArgs, Object, StringUtil.Subcommand> cliApp;
    private static ZLayer<ZIOAppArgs, Object, Object> bootstrap;
    private static Tag<Object> environmentTag;
    private static AtomicBoolean shuttingDown;

    static {
        ZIOAppPlatformSpecific.$init$((ZIOAppPlatformSpecific)MODULE$);
        ZIOAppVersionSpecific.$init$((ZIOAppVersionSpecific)MODULE$);
        ZIOApp.$init$((ZIOApp)MODULE$);
        ZIOCli.$init$((ZIOCli)MODULE$);
        ZIOAppDefault.$init$((ZIOAppDefault)MODULE$);
        firstOption = Options$.MODULE$.boolean("first", Options$.MODULE$.boolean$default$2()).alias("f", (Seq)Nil$.MODULE$).$qmark$qmark("Display just the first substring.");
        separatorOption = Options$.MODULE$.text("separator").alias("s", (Seq)Nil$.MODULE$).withDefault((Object)",").$qmark$qmark("Separator regex.");
        stringArg = Args$.MODULE$.text("string").$qmark$qmark("String to split.");
        split = Command$.MODULE$.apply("split", MODULE$.firstOption().$plus$plus(MODULE$.separatorOption(), Zippable$.MODULE$.Zippable2()), MODULE$.stringArg(), Reducable$.MODULE$.tuple()).withHelp(HelpDoc$.MODULE$.p("Split a string into substrings and display as an array")).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Tuple2 tuple2 = (Tuple2)x0$1._1();
                String string = (String)x0$1._2();
                if (tuple2 != null) {
                    boolean first = tuple2._1$mcZ$sp();
                    String separator = (String)tuple2._2();
                    return new StringUtil.Subcommand.Split(string, first, separator);
                }
            }
            throw new MatchError(x0$1);
        });
        join = Command$.MODULE$.apply("join", MODULE$.separatorOption(), Args$.MODULE$.text("string").$plus().$qmark$qmark("Strings to join."), Reducable$.MODULE$.tuple()).withHelp(HelpDoc$.MODULE$.p("Join the command-arguments into a single string")).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String separator = (String)x0$2._1();
                .colon.colon strings = (.colon.colon)x0$2._2();
                return new StringUtil.Subcommand.Join((NonEmptyChunk<String>)NonEmptyChunk$.MODULE$.fromCons(strings), separator);
            }
            throw new MatchError(null);
        });
        stringUtil = Command$.MODULE$.apply("string-util", Options$.MODULE$.none(), Args$.MODULE$.none(), Reducable$.MODULE$.ReducableLeftIdentity()).subcommands(MODULE$.split(), MODULE$.join(), (Seq)Nil$.MODULE$, Reducable$.MODULE$.ReducableLeftIdentity());
        HelpDoc.Span x$3 = HelpDoc.Span$.MODULE$.text("CLI to some string utilities");
        HelpDoc x$4 = HelpDoc$.MODULE$.p("\u00a9Copyright 2022");
        Command<StringUtil.Subcommand> x$5 = MODULE$.stringUtil();
        CliConfig x$6 = CliApp$.MODULE$.make$default$6();
        FigFont x$7 = CliApp$.MODULE$.make$default$7();
        Function1 & Serializable x$8 = (Function1 & Serializable)x0$3 -> {
            if (x0$3 instanceof StringUtil.Subcommand.Split) {
                StringUtil.Subcommand.Split split = (StringUtil.Subcommand.Split)x0$3;
                String string = split.string();
                boolean first = split.first();
                String separator = split.separator();
                String[] elements = string.split(separator);
                return Console$.MODULE$.printLine((Function0 & Serializable)() -> {
                    if (first) {
                        return ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])elements)).getOrElse((Function0 & Serializable)() -> "");
                    }
                    return Predef$.MODULE$.wrapRefArray((Object[])elements).mkString("[", ", ", "]");
                }, (Object)"zio.cli.examples.StringUtil.cliApp(StringUtil.scala:46)");
            }
            if (x0$3 instanceof StringUtil.Subcommand.Join) {
                StringUtil.Subcommand.Join join = (StringUtil.Subcommand.Join)x0$3;
                NonEmptyChunk<String> strings = join.strings();
                String separator = join.separator();
                return Console$.MODULE$.printLine((Function0 & Serializable)() -> NonEmptyChunk$.MODULE$.toChunk(strings).mkString(separator), (Object)"zio.cli.examples.StringUtil.cliApp(StringUtil.scala:48)");
            }
            throw new MatchError(x0$3);
        };
        cliApp = CliApp$.MODULE$.make("String Util", "0.0.1", x$3, x$5, x$4, x$6, x$7, (Function1)x$8);
    }

    public ZIO<ZIOAppArgs, Object, Object> run() {
        return ZIOCli.run$((ZIOCli)this);
    }

    public final ZIOApp $less$greater(ZIOApp that, Object trace) {
        return ZIOApp.$less$greater$((ZIOApp)this, (ZIOApp)that, (Object)trace);
    }

    public final ZIO<ZIOAppArgs, Nothing$, Chunk<String>> getArgs(Object trace) {
        return ZIOApp.getArgs$((ZIOApp)this, (Object)trace);
    }

    public final ZIO<Object, Nothing$, BoxedUnit> exit(ExitCode code, Object trace) {
        return ZIOApp.exit$((ZIOApp)this, (ExitCode)code, (Object)trace);
    }

    public final ZIO<Object, Object, Object> invoke(Chunk<String> args, Object trace) {
        return ZIOApp.invoke$((ZIOApp)this, args, (Object)trace);
    }

    public Runtime<Object> runtime() {
        return ZIOApp.runtime$((ZIOApp)this);
    }

    public ZIO<Object, Nothing$, Object> installSignalHandlers(Runtime<Object> runtime, Object trace) {
        return ZIOApp.installSignalHandlers$((ZIOApp)this, runtime, (Object)trace);
    }

    public final void main(String[] args0) {
        ZIOAppPlatformSpecific.main$((ZIOAppPlatformSpecific)this, (String[])args0);
    }

    public ZLayer<ZIOAppArgs, Object, Object> bootstrap() {
        return bootstrap;
    }

    public Tag<Object> environmentTag() {
        return environmentTag;
    }

    public void zio$ZIOAppDefault$_setter_$bootstrap_$eq(ZLayer<ZIOAppArgs, Object, Object> x$1) {
        bootstrap = x$1;
    }

    public void zio$ZIOAppDefault$_setter_$environmentTag_$eq(Tag<Object> x$1) {
        environmentTag = x$1;
    }

    public AtomicBoolean shuttingDown() {
        return shuttingDown;
    }

    public void zio$ZIOApp$_setter_$shuttingDown_$eq(AtomicBoolean x$1) {
        shuttingDown = x$1;
    }

    public Options<Object> firstOption() {
        return firstOption;
    }

    public Options<String> separatorOption() {
        return separatorOption;
    }

    public Args<String> stringArg() {
        return stringArg;
    }

    public Command<StringUtil.Subcommand.Split> split() {
        return split;
    }

    public Command<StringUtil.Subcommand.Join> join() {
        return join;
    }

    public Command<StringUtil.Subcommand> stringUtil() {
        return stringUtil;
    }

    public CliApp<ZIOAppArgs, Object, StringUtil.Subcommand> cliApp() {
        return cliApp;
    }

    private StringUtil$() {
    }
}

