/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import org.specs2.Specification;
import org.specs2.matcher.MatchResult;
import org.specs2.matcher.MatchResult$;
import org.specs2.matcher.describe.Diffable$;
import org.specs2.specification.core.AsExecution$;
import org.specs2.specification.core.SpecStructure;
import org.specs2.specification.create.InterpolatedFragment;
import scala.Function0;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import zio.SerializableSpec$;
import zio.internal.MutableConcurrentQueue;
import zio.internal.MutableConcurrentQueue$;

@ScalaSignature(bytes="\u0006\u0005\t3Aa\u0003\u0007\u0001#!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!)\u0001\u0006\u0001C\u0001S!)a\u0007\u0001C\u0001S!)q\u0007\u0001C\u0001S!)\u0001\b\u0001C\u0001s!)a\b\u0001C\u0001s!)q\b\u0001C\u0001S!)\u0001\t\u0001C\u0001S!)\u0011\t\u0001C\u0001S\tQR*\u001e;bE2,7i\u001c8dkJ\u0014XM\u001c;Rk\u0016,Xm\u00159fG*\u0011QBD\u0001\tS:$XM\u001d8bY*\tq\"A\u0002{S>\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0007gB,7m\u001d\u001a\u000b\u0003]\t1a\u001c:h\u0013\tIBCA\u0007Ta\u0016\u001c\u0017NZ5dCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u00031\t!![:\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\t\r|'/\u001a\u0006\u0003KQ\tQb\u001d9fG&4\u0017nY1uS>t\u0017BA\u0014#\u00055\u0019\u0006/Z2TiJ,8\r^;sK\u00069Q.\u001b8TSj,W#\u0001\u0016\u0011\u0007-r\u0003'D\u0001-\u0015\tiC#A\u0004nCR\u001c\u0007.\u001a:\n\u0005=b#aC'bi\u000eD'+Z:vYR\u0004\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u00121!\u00138u\u0003))\u00070Y2u'&TX-M\u0001\u000bKb\f7\r^*ju\u0016\u0014\u0014AC8gM\u0016\u00148\t[3dWV\t!\bE\u0002,]m\u0002\"!\r\u001f\n\u0005u\u0012$AB!osZ\u000bG.A\u0005q_2d7\t[3dW\u0006QqN\\3FYN+'\u000fR3\u0002\u0013A|wOM*fe\u0012+\u0017\u0001C1sEN+'\u000fR3")
public class MutableConcurrentQueueSpec
extends Specification {
    public SpecStructure is() {
        return this.appendSpecStructureToSpecHeader(this.title("MutableConcurrentQueueSpec").title()).$up((Function0 & Serializable)() -> this.s2("\n    Make a bounded MutableConcurrentQueue\n     of capacity 1 return a queue of capacity 1. $minSize\n     of capacity 2 returns a queue of capacity 2. $exactSize1\n     of capacity 3 returns a queue of capacity 3. $exactSize2\n\n    With a RingBuffer of capacity 2\n     `offer` of 2 items succeeds, further offers fail. $offerCheck\n     `poll` of 2 items from full queue succeeds, further `poll`s return default value. $pollCheck\n\n    Serialization works for\n     a one element queue. $oneElSerDe\n     a pow 2 capacity ring buffer. $pow2SerDe\n     an arbitrary capacity ring buffer. $arbSerDe\n    \"\"\"\n\n  def minSize = {\n    val q = MutableConcurrentQueue.bounded(1)\n    q.capacity must_=== 1\n  }\n\n  def exactSize1 = {\n    val q = MutableConcurrentQueue.bounded(2)\n    q.capacity must_=== 2\n  }\n\n  def exactSize2 = {\n    val q = MutableConcurrentQueue.bounded(3)\n    q.capacity must_=== 3\n  }\n\n  def offerCheck = {\n    val q = MutableConcurrentQueue.bounded[Int](2)\n    (q.offer(1) must beTrue)\n      .and(q.size() must_=== 1)\n      .and(q.offer(2) must beTrue)\n      .and(q.size() must_=== 2)\n      .and(q.offer(3) must beFalse)\n      .and(q.isFull() must beTrue)\n  }\n\n  def pollCheck = {\n    val q = MutableConcurrentQueue.bounded[Int](2)\n    q.offer(1)\n    q.offer(2)\n    (q.poll(-1) must_=== 1)\n      .and(q.poll(-1) must_=== 2)\n      .and(q.poll(-1) must_=== -1)\n      .and(q.isEmpty() must beTrue)\n  }\n\n  def oneElSerDe = {\n    val q = MutableConcurrentQueue.bounded[Int](1)\n    q.offer(1)\n    val returnQ = serializeAndDeserialize(q)\n    returnQ.offer(2)\n    (returnQ.poll(-1) must_=== 1)\n      .and(returnQ.poll(-1) must_=== -1)\n  }\n\n  def pow2SerDe = {\n    val q = MutableConcurrentQueue.bounded[Int](3)\n    q.offer(1)\n    val returnQ = serializeAndDeserialize(q)\n    returnQ.offer(2)\n    (returnQ.poll(-1) must_=== 1)\n      .and(returnQ.poll(-1) must_=== 2)\n      .and(returnQ.poll(-1) must_=== -1)\n  }\n\n  def arbSerDe = {\n    val q = MutableConcurrentQueue.bounded[Int](2)\n    q.offer(1)\n    val returnQ = serializeAndDeserialize(q)\n    returnQ.offer(2)\n    (returnQ.poll(-1) must_=== 1)\n      .and(returnQ.poll(-1) must_=== 2)\n      .and(returnQ.poll(-1) must_=== -1)\n  }\n}", true, (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    Make a bounded MutableConcurrentQueue\n     of capacity 1 return a queue of capacity 1. ", "\n     of capacity 2 returns a queue of capacity 2. ", "\n     of capacity 3 returns a queue of capacity 3. ", "\n\n    With a RingBuffer of capacity 2\n     `offer` of 2 items succeeds, further offers fail. ", "\n     `poll` of 2 items from full queue succeeds, further `poll`s return default value. ", "\n\n    Serialization works for\n     a one element queue. ", "\n     a pow 2 capacity ring buffer. ", "\n     an arbitrary capacity ring buffer. ", "\n    "})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|14", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|16", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|17", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|18", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|21", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|22", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|25", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|26", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|27"})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|16", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|17", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|18", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|21", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|22", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|25", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|26", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|27", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/internal/MutableConcurrentQueueSpec.scala|MutableConcurrentQueueSpec.scala|28"})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InterpolatedFragment[]{this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.minSize(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.exactSize1(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.exactSize2(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.offerCheck(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pollCheck(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.oneElSerDe(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pow2SerDe(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.arbSerDe(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()))})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"minSize", "exactSize1", "exactSize2", "offerCheck", "pollCheck", "oneElSerDe", "pow2SerDe", "arbSerDe"}))));
    }

    public MatchResult<Object> minSize() {
        MutableConcurrentQueue q = MutableConcurrentQueue$.MODULE$.bounded(1);
        return this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> q.capacity()).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 1, Diffable$.MODULE$.intDiffable());
    }

    public MatchResult<Object> exactSize1() {
        MutableConcurrentQueue q = MutableConcurrentQueue$.MODULE$.bounded(2);
        return this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> q.capacity()).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 2, Diffable$.MODULE$.intDiffable());
    }

    public MatchResult<Object> exactSize2() {
        MutableConcurrentQueue q = MutableConcurrentQueue$.MODULE$.bounded(3);
        return this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> q.capacity()).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 3, Diffable$.MODULE$.intDiffable());
    }

    public MatchResult<Object> offerCheck() {
        MutableConcurrentQueue q = MutableConcurrentQueue$.MODULE$.bounded(2);
        return this.combineMatchResult((Function0 & Serializable)() -> this.combineMatchResult((Function0 & Serializable)() -> this.combineMatchResult((Function0 & Serializable)() -> this.combineMatchResult((Function0 & Serializable)() -> this.combineMatchResult((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcZ.sp & Serializable)() -> q.offer((Object)BoxesRunTime.boxToInteger((int)1))).must((Function0 & Serializable)() -> this.beTrue())).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> q.size()).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 1, Diffable$.MODULE$.intDiffable()))).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcZ.sp & Serializable)() -> q.offer((Object)BoxesRunTime.boxToInteger((int)2))).must((Function0 & Serializable)() -> this.beTrue()))).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> q.size()).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 2, Diffable$.MODULE$.intDiffable()))).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcZ.sp & Serializable)() -> q.offer((Object)BoxesRunTime.boxToInteger((int)3))).must((Function0 & Serializable)() -> this.beFalse()))).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcZ.sp & Serializable)() -> q.isFull()).must((Function0 & Serializable)() -> this.beTrue()));
    }

    public MatchResult<Object> pollCheck() {
        MutableConcurrentQueue q = MutableConcurrentQueue$.MODULE$.bounded(2);
        q.offer((Object)BoxesRunTime.boxToInteger((int)1));
        q.offer((Object)BoxesRunTime.boxToInteger((int)2));
        return this.combineMatchResult((Function0 & Serializable)() -> this.combineMatchResult((Function0 & Serializable)() -> this.combineMatchResult((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)q.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 1, Diffable$.MODULE$.intDiffable())).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)q.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 2, Diffable$.MODULE$.intDiffable()))).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)q.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> -1, Diffable$.MODULE$.intDiffable()))).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcZ.sp & Serializable)() -> q.isEmpty()).must((Function0 & Serializable)() -> this.beTrue()));
    }

    public MatchResult<Object> oneElSerDe() {
        MutableConcurrentQueue q = MutableConcurrentQueue$.MODULE$.bounded(1);
        q.offer((Object)BoxesRunTime.boxToInteger((int)1));
        MutableConcurrentQueue returnQ = SerializableSpec$.MODULE$.serializeAndDeserialize(q);
        returnQ.offer((Object)BoxesRunTime.boxToInteger((int)2));
        return this.combineMatchResult((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)returnQ.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 1, Diffable$.MODULE$.intDiffable())).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)returnQ.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> -1, Diffable$.MODULE$.intDiffable()));
    }

    public MatchResult<Object> pow2SerDe() {
        MutableConcurrentQueue q = MutableConcurrentQueue$.MODULE$.bounded(3);
        q.offer((Object)BoxesRunTime.boxToInteger((int)1));
        MutableConcurrentQueue returnQ = SerializableSpec$.MODULE$.serializeAndDeserialize(q);
        returnQ.offer((Object)BoxesRunTime.boxToInteger((int)2));
        return this.combineMatchResult((Function0 & Serializable)() -> this.combineMatchResult((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)returnQ.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 1, Diffable$.MODULE$.intDiffable())).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)returnQ.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 2, Diffable$.MODULE$.intDiffable()))).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)returnQ.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> -1, Diffable$.MODULE$.intDiffable()));
    }

    public MatchResult<Object> arbSerDe() {
        MutableConcurrentQueue q = MutableConcurrentQueue$.MODULE$.bounded(2);
        q.offer((Object)BoxesRunTime.boxToInteger((int)1));
        MutableConcurrentQueue returnQ = SerializableSpec$.MODULE$.serializeAndDeserialize(q);
        returnQ.offer((Object)BoxesRunTime.boxToInteger((int)2));
        return this.combineMatchResult((Function0 & Serializable)() -> this.combineMatchResult((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)returnQ.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 1, Diffable$.MODULE$.intDiffable())).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)returnQ.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 2, Diffable$.MODULE$.intDiffable()))).and((Function0 & Serializable)() -> this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)returnQ.poll((Object)BoxesRunTime.boxToInteger((int)-1)))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> -1, Diffable$.MODULE$.intDiffable()));
    }
}

