/*
 * Decompiled with CFR 0.152.
 */
package zio.blocking;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.specs2.concurrent.ExecutionEnv;
import org.specs2.matcher.MatchResult;
import org.specs2.matcher.MatchResult$;
import org.specs2.matcher.describe.Diffable$;
import org.specs2.specification.core.AsExecution$;
import org.specs2.specification.core.SpecStructure;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import zio.TestRuntime;
import zio.UIO$;
import zio.ZIO;
import zio.blocking.package$;
import zio.duration.Duration$;

@ScalaSignature(bytes="\u0006\u0005M3A!\u0003\u0006\u0003\u001f!AA\u0003\u0001B\u0001B\u0003-Q\u0003C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00030\u0001\u0011\u0005\u0001\u0007C\u0003>\u0001\u0011\u0005\u0001\u0007C\u0003?\u0001\u0011\u0005q\bC\u0003\f\u0001\u0011\u0005A\tC\u0003S\u0001\u0011\u0005qH\u0001\u0007CY>\u001c7.\u001b8h'B,7M\u0003\u0002\f\u0019\u0005A!\r\\8dW&twMC\u0001\u000e\u0003\rQ\u0018n\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\tA\"\u0003\u0002\u0014\u0019\tYA+Z:u%VtG/[7f\u0003\t)W\r\u0005\u0002\u0017;5\tqC\u0003\u0002\u00193\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005iY\u0012AB:qK\u000e\u001c(GC\u0001\u001d\u0003\ry'oZ\u0005\u0003=]\u0011A\"\u0012=fGV$\u0018n\u001c8F]Z\fa\u0001P5oSRtD#A\u0011\u0015\u0005\t\"\u0003CA\u0012\u0001\u001b\u0005Q\u0001\"\u0002\u000b\u0003\u0001\b)\u0012AA5t+\u00059\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0011\u0019wN]3\u000b\u00051J\u0012!D:qK\u000eLg-[2bi&|g.\u0003\u0002/S\ti1\u000b]3d'R\u0014Xo\u0019;ve\u0016\f!!Z\u0019\u0016\u0003E\u00022AM\u001b8\u001b\u0005\u0019$B\u0001\u001b\u001a\u0003\u001di\u0017\r^2iKJL!AN\u001a\u0003\u00175\u000bGo\u00195SKN,H\u000e\u001e\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0005+:LG/\u0001\u0002fe\u0005\u0011QmM\u000b\u0002\u0001B\u0019!'N!\u0011\u0007a\u0012u'\u0003\u0002Ds\t1q\n\u001d;j_:$\"aN#\t\u000b\u0019;\u0001\u0019A$\u0002\u0011I,G.Z1tK\u0012\u0004\"\u0001\u0013)\u000e\u0003%S!AS&\u0002\r\u0005$x.\\5d\u0015\tABJ\u0003\u0002N\u001d\u0006!Q\u000f^5m\u0015\u0005y\u0015\u0001\u00026bm\u0006L!!U%\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\t)G\u0007")
public final class BlockingSpec
extends TestRuntime {
    public SpecStructure is() {
        return this.appendSpecStructureToSpecHeader(this.title("BlockingSpec").title()).$up((Function0 & Serializable)() -> this.s2("\n    Make a Blocking Service and\n    verify that\n      `effectBlocking` completes successfully $e1\n      `effectBlockingCancelable` completes successfully $e2\n      `effectBlocking` can be interrupted $e3\n      `effectBlockingCancelable` can be interrupted $e4\n    \"\"\"\n\n  def e1 =\n    unsafeRun(effectBlocking(())).must_===(())\n\n  def e2 =\n    unsafeRun(effectBlockingCancelable(())(UIO.unit)).must_===(())\n\n  def e3 = {\n    val res = unsafeRun(effectBlocking(Thread.sleep(50000)).timeout(Duration.Zero))\n    res must beNone\n  }\n\n  def blocking(released: AtomicBoolean) =\n    while (!released.get()) {\n      try {\n        Thread.sleep(10L)\n      } catch {\n        case _: InterruptedException => ()\n      }\n    }\n\n  def e4 = {\n    val release = new AtomicBoolean(false)\n    val cancel  = UIO.effectTotal(release.set(true))\n    val res     = unsafeRun(effectBlockingCancelable(blocking(release))(cancel).timeout(Duration.Zero))\n    res must beNone\n  }\n}", true, (Seq)new .colon.colon((Object)"\n    Make a Blocking Service and\n    verify that\n      `effectBlocking` completes successfully ", (List)new .colon.colon((Object)"\n      `effectBlockingCancelable` completes successfully ", (List)new .colon.colon((Object)"\n      `effectBlocking` can be interrupted ", (List)new .colon.colon((Object)"\n      `effectBlockingCancelable` can be interrupted ", (List)new .colon.colon((Object)"\n    ", (List)Nil$.MODULE$))))), (Seq)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|12", (List)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|15", (List)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|16", (List)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|17", (List)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|18", (List)Nil$.MODULE$))))), (Seq)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|15", (List)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|16", (List)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|17", (List)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|18", (List)new .colon.colon((Object)"/home/circleci/project/core-tests/jvm/src/test/scala/zio/blocking/BlockingSpec.scala|BlockingSpec.scala|19", (List)Nil$.MODULE$))))), (Seq)new .colon.colon((Object)this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e1(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), (List)new .colon.colon((Object)this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e2(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), (List)new .colon.colon((Object)this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e3(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), (List)new .colon.colon((Object)this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e4(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), (List)Nil$.MODULE$)))), (Seq)new .colon.colon((Object)"e1", (List)new .colon.colon((Object)"e2", (List)new .colon.colon((Object)"e3", (List)new .colon.colon((Object)"e4", (List)Nil$.MODULE$))))));
    }

    public MatchResult<BoxedUnit> e1() {
        return this.theValue((Function0)(JFunction0.mcV.sp & Serializable)() -> this.unsafeRun((Function0 & Serializable)() -> package$.MODULE$.effectBlocking((Function0)(JFunction0.mcV.sp & Serializable)() -> {}))).must_$eq$eq$eq((Function0)(JFunction0.mcV.sp & Serializable)() -> {}, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<BoxedUnit> e2() {
        return this.theValue((Function0)(JFunction0.mcV.sp & Serializable)() -> this.unsafeRun((Function0 & Serializable)() -> package$.MODULE$.effectBlockingCancelable((Function0)(JFunction0.mcV.sp & Serializable)() -> {}, UIO$.MODULE$.unit()))).must_$eq$eq$eq((Function0)(JFunction0.mcV.sp & Serializable)() -> {}, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Option<BoxedUnit>> e3() {
        Option res = (Option)this.unsafeRun((Function0 & Serializable)() -> package$.MODULE$.effectBlocking((Function0)(JFunction0.mcV.sp & Serializable)() -> Thread.sleep(50000L)).timeout(Duration$.MODULE$.Zero()));
        return this.theValue((Function0 & Serializable)() -> res).must((Function0 & Serializable)() -> this.beNone());
    }

    public void blocking(AtomicBoolean released) {
        while (!released.get()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public MatchResult<Option<BoxedUnit>> e4() {
        AtomicBoolean release = new AtomicBoolean(false);
        ZIO cancel = UIO$.MODULE$.effectTotal((Function0)(JFunction0.mcV.sp & Serializable)() -> release.set(true));
        Option res = (Option)this.unsafeRun((Function0 & Serializable)() -> package$.MODULE$.effectBlockingCancelable((Function0)(JFunction0.mcV.sp & Serializable)() -> this.blocking(release), cancel).timeout(Duration$.MODULE$.Zero()));
        return this.theValue((Function0 & Serializable)() -> res).must((Function0 & Serializable)() -> this.beNone());
    }

    public BlockingSpec(ExecutionEnv ee) {
        super(ee);
    }
}

