/*
 * Decompiled with CFR 0.152.
 */
package zio.duration;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.specs2.Specification;
import org.specs2.matcher.MatchResult;
import org.specs2.matcher.MatchResult$;
import org.specs2.matcher.describe.Diffable$;
import org.specs2.specification.core.AsExecution$;
import org.specs2.specification.core.SpecStructure;
import org.specs2.specification.create.InterpolatedFragment;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import zio.duration.Duration;
import zio.duration.Duration$;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\u001b7\u0001mBQ\u0001\u0012\u0001\u0005\u0002\u0015CQ\u0001\u0013\u0001\u0005\u0002%CQA\u0015\u0001\u0005\u0002MCQ!\u0018\u0001\u0005\u0002MCQA\u0018\u0001\u0005\u0002MCQa\u0018\u0001\u0005\u0002\u0001DQA\u001b\u0001\u0005\u0002-DQ\u0001\u001e\u0001\u0005\u0002UDQa\u001f\u0001\u0005\u0002MCQ\u0001 \u0001\u0005\u0002uDa!!\u0002\u0001\t\u0003i\bBBA\u0004\u0001\u0011\u00051\u000b\u0003\u0004\u0002\n\u0001!\ta\u0015\u0005\u0007\u0003\u0017\u0001A\u0011A*\t\r\u00055\u0001\u0001\"\u0001T\u0011\u0019\ty\u0001\u0001C\u0001'\"1\u0011\u0011\u0003\u0001\u0005\u0002MCq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u0002 \u0001!\t!!\u0006\t\r\u0005\u0005\u0002\u0001\"\u0001T\u0011\u0019\t\u0019\u0003\u0001C\u0001'\"1\u0011Q\u0005\u0001\u0005\u0002MCa!a\n\u0001\t\u0003\u0019\u0006bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\u0007\u0003w\u0001A\u0011A*\t\r\u0005u\u0002\u0001\"\u0001~\u0011\u0019\ty\u0004\u0001C\u0001{\"1\u0011\u0011\t\u0001\u0005\u0002MCa!a\u0011\u0001\t\u0003\u0019\u0006BBA#\u0001\u0011\u00051\u000b\u0003\u0004\u0002H\u0001!\ta\u0015\u0005\b\u0003\u0013\u0002A\u0011AA\u000b\u0011\u001d\tY\u0005\u0001C\u0001\u0003+Aa!!\u0014\u0001\t\u0003)\bBBA(\u0001\u0011\u0005\u0001\r\u0003\u0004\u0002R\u0001!\ta\u001b\u0005\b\u0003'\u0002A\u0011AA\u0016\u0011\u0019\t)\u0006\u0001C\u0001'\"1\u0011q\u000b\u0001\u0005\u0002MCa!!\u0017\u0001\t\u0003\u0019\u0006BBA.\u0001\u0011\u00051\u000b\u0003\u0004\u0002^\u0001!\ta\u0015\u0005\u0007\u0003?\u0002A\u0011A*\t\r\u0005\u0005\u0004\u0001\"\u0001T\u0011\u0019\t\u0019\u0007\u0001C\u0001'\"1\u0011Q\r\u0001\u0005\u0002MCa!a\u001a\u0001\t\u0003\u0019\u0006BBA5\u0001\u0011\u00051\u000b\u0003\u0004\u0002l\u0001!\ta\u0015\u0005\u0007\u0003[\u0002A\u0011A*\t\r\u0005=\u0004\u0001\"\u0001T\u0011\u0019\t\t\b\u0001C\u0001'\naA)\u001e:bi&|gn\u00159fG*\u0011q\u0007O\u0001\tIV\u0014\u0018\r^5p]*\t\u0011(A\u0002{S>\u001c\u0001a\u0005\u0002\u0001yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0007gB,7m\u001d\u001a\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019eHA\u0007Ta\u0016\u001c\u0017NZ5dCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0003\"a\u0012\u0001\u000e\u0003Y\n!![:\u0016\u0003)\u0003\"a\u0013)\u000e\u00031S!!\u0014(\u0002\t\r|'/\u001a\u0006\u0003\u001fz\nQb\u001d9fG&4\u0017nY1uS>t\u0017BA)M\u00055\u0019\u0006/Z2TiJ,8\r^;sK\u0006!\u0001o\\:2+\u0005!\u0006cA+Y56\taK\u0003\u0002X}\u00059Q.\u0019;dQ\u0016\u0014\u0018BA-W\u0005-i\u0015\r^2i%\u0016\u001cX\u000f\u001c;\u0011\u0005\u001d[\u0016B\u0001/7\u0005!!UO]1uS>t\u0017\u0001\u00029pgJ\nA\u0001]8tg\u0005!\u0001o\\:5+\u0005\t\u0007cA+YEB\u00111-[\u0007\u0002I*\u0011q'\u001a\u0006\u0003M\u001e\f!bY8oGV\u0014(/\u001a8u\u0015\u0005A\u0017!B:dC2\f\u0017B\u0001/e\u0003\u0011\u0001xn]\u001b\u0016\u00031\u00042!\u0016-n!\tq7/D\u0001p\u0015\t\u0001\u0018/\u0001\u0003uS6,'\"\u0001:\u0002\t)\fg/Y\u0005\u00039>\fA\u0001]8tmU\ta\u000fE\u0002V1^\u0004\"\u0001_=\u000e\u0003\u001dL!A_4\u0003\u000f\t{w\u000e\\3b]\u0006!\u0001o\\:8\u0003\u0011\u0001xn\u001d\u001d\u0016\u0003y\u00042!\u0016-\u0000!\rA\u0018\u0011A\u0005\u0004\u0003\u00079'\u0001\u0002'p]\u001e\fA\u0001]8ts\u0005)\u0001o\\:2a\u0005)\u0001o\\:2c\u0005)\u0001o\\:2e\u0005)\u0001o\\:2g\u0005)\u0001o\\:2i\u0005)\u0001o\\:2k\u0005)\u0001o\\:2mU\u0011\u0011q\u0003\t\u0005+b\u000bI\u0002E\u0002y\u00037I1!!\bh\u0005\rIe\u000e^\u0001\u0006a>\u001c\u0018gN\u0001\u0006a>\u001c\u0018\u0007O\u0001\u0006a>\u001c\u0018'O\u0001\u0006a>\u001c(\u0007M\u0001\u0006a>\u001c('M\u0001\u0006a>\u001c(GM\u000b\u0003\u0003[\u0001B!\u0016-\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026E\fA\u0001\\1oO&!\u0011\u0011HA\u001a\u0005\u0019\u0019FO]5oO\u0006!a.Z42\u0003\u0011IgNZ\u0019\u0002\t%tgMM\u0001\u0005S:47'\u0001\u0003j]\u001a$\u0014\u0001B5oMV\nA!\u001b8gm\u0005!\u0011N\u001c48\u0003\u0011IgN\u001a\u001d\u0002\t%tg-O\u0001\u0006S:4\u0017\u0007M\u0001\u0006S:4\u0017'M\u0001\u0006S:4\u0017GM\u0001\u0006S:4\u0017gM\u0001\u0005IV\u0014\u0018'\u0001\u0003ekJ\u0014\u0014\u0001\u00023veN\nQA\u001b3veF\nQA\u001b3veJ\nQA\u001b3veN\nQA\u001b3veR\nQA\u001b3veV\nQA\u001b3veZ\nQA\u001b3ve^\nQA\u001b3veb\nA!\\;ma\u0005!Q.\u001e72\u0003\u0011iW\u000f\u001c\u001a")
public class DurationSpec
extends Specification {
    public SpecStructure is() {
        return this.appendSpecStructureToSpecHeader(this.title("DurationSpec").title()).$up((Function0 & Serializable)() -> this.s2("\n        Make a Duration from positive nanos and check that:\n          The Duration is Finite                                               $pos1\n          Copy with a negative nanos returns Zero                              $pos2\n          Multiplying with a negative factor returns Zero                      $pos3\n          Its stdlib representation is correct                                 $pos4\n          Its JDK representation is correct                                    $pos5\n          It identifies as \"zero\"                                              $pos6\n          Creating it with a j.u.c.TimeUnit is identical                       $pos7\n          It knows its length in ns                                            $pos8\n          It knows its length in ms                                            $pos9\n          max(1 ns, 2 ns) is 2 ns                                              $pos10\n          min(1 ns, 2 ns) is 1 ns                                              $pos11\n          max(2 ns, 1 ns) is 2 ns                                              $pos12\n          min(2 ns, 1 ns) is 1 ns                                              $pos13\n          10 ns + 20 ns = 30 ns                                                $pos14\n          10 ns * NaN = Infinity                                               $pos15\n          10 ns compared to Infinity is -1                                     $pos16\n          10 ns compared to 10 ns is 0                                         $pos17\n          + with positive overflow results in Infinity                         $pos18\n          * with negative duration results in zero                             $pos19\n          * with overflow to positive results in Infinity                      $pos20\n          * with overflow to negative results in Infinity                      $pos21\n          Folding picks up the correct value                                   $pos22\n\n        Make a Duration from negative nanos and check that:\n          The Duration is Zero                                                 $neg1\n\n        Take Infinity and check that:\n          It returns -1 milliseconds                                           $inf1\n          It returns -1 nanoseconds                                            $inf2\n          Infinity + Infinity = Infinity                                       $inf3\n          Infinity + 1 ns = Infinity                                           $inf4\n          1 ns + Infinity = Infinity                                           $inf5\n          Infinity * 10 = Infinity                                             $inf6\n          Infinity compared to Infinity is 0                                   $inf7\n          Infinity compared to 1 ns is 1                                       $inf8\n          Infinity is not zero                                                 $inf9\n          It converts into the infinite s.c.d.Duration                         $inf10\n          It converts into a Long.MaxValue second-long JDK Duration            $inf11\n          Folding picks up the correct value                                   $inf12\n          Infinity * -10 = Zero                                                $inf13\n\n        Make a Scala stdlib s.c.d.Duration and check that:\n          A negative s.c.d.Duration converts to Zero                           $dur1\n          The infinite s.c.d.Duration converts to Infinity                     $dur2\n          A positive s.c.d.Duration converts to a Finite                       $dur3\n\n        Make a Java stdlib j.t.Duration and check that:\n          A negative j.t.Duration converts to Zero                                $jdur1\n          A Long.MaxValue second j.t.Duration converts to Infinity                $jdur2\n          A nano-adjusted Long.MaxValue second j.t.Duration converts to Infinity  $jdur3\n          A j.t.Duration constructed from Infinity converts to Infinity           $jdur4\n          A Long.MaxValue - 1 second j.t.Duration converts to Infinity            $jdur5\n          A +ve j.t.Duration whose nano conversion overflows converts to Infinity $jdur6\n          A -ve j.t.Duration whose nano conversion overflows converts to Zero     $jdur7\n          A positive j.t.Duration converts to a Finite                            $jdur8\n\n        Check multiplication with finite durations:\n          Zero multiplied with zero                                            $mul0\n          Zero multiplied with one                                             $mul1\n          One second multiplied with 60                                        $mul2\n     \"\"\"\n\n  def pos1 =\n    Duration.fromNanos(1) must haveClass[Duration.Finite]\n\n  def pos2 =\n    Duration.fromNanos(1).asInstanceOf[Duration.Finite].copy(-1) must_=== Duration.Zero\n\n  def pos3 =\n    Duration.fromNanos(1) * -1.0 must_=== Duration.Zero\n\n  def pos4 =\n    Duration.fromNanos(1234L).asScala must_=== ScalaFiniteDuration(1234L, TimeUnit.NANOSECONDS)\n\n  def pos5 =\n    Duration.fromNanos(2345L).asJava must_=== JavaDuration.ofNanos(2345L)\n\n  def pos6 =\n    Duration.fromNanos(0L).isZero must_=== true\n\n  def pos7 =\n    Duration(12L, TimeUnit.NANOSECONDS) must_=== Duration.fromNanos(12L)\n\n  def pos8 =\n    Duration.fromNanos(123L).toNanos must_=== 123L\n\n  def pos9 =\n    Duration.fromNanos(123000000L).toMillis must_=== 123L\n\n  def pos10 =\n    Duration.fromNanos(1L).max(Duration.fromNanos(2L)) must_=== Duration.fromNanos(2L)\n\n  def pos11 =\n    Duration.fromNanos(1L).min(Duration.fromNanos(2L)) must_=== Duration.fromNanos(1L)\n\n  def pos12 =\n    Duration.fromNanos(2L).max(Duration.fromNanos(1L)) must_=== Duration.fromNanos(2L)\n\n  def pos13 =\n    Duration.fromNanos(2L).min(Duration.fromNanos(1L)) must_=== Duration.fromNanos(1L)\n\n  def pos14 =\n    Duration.fromNanos(10L) + Duration.fromNanos(20L) must_=== Duration.fromNanos(30L)\n\n  def pos15 =\n    Duration.fromNanos(10L) * Double.NaN must_=== Duration.Infinity\n\n  def pos16 =\n    Duration.fromNanos(10L) compare Duration.Infinity must_=== -1\n\n  def pos17 =\n    Duration.fromNanos(10L) compare Duration.fromNanos(10L) must_=== 0\n\n  def pos18 =\n    Duration.fromNanos(Long.MaxValue - 1) + Duration.fromNanos(42) must_=== Duration.Infinity\n\n  def pos19 =\n    Duration.fromNanos(42) * -7 must_=== Duration.Zero\n\n  def pos20 =\n    Duration.fromNanos(Long.MaxValue) * 3 must_=== Duration.Infinity\n\n  def pos21 =\n    Duration.fromNanos(Long.MaxValue) * 2 must_=== Duration.Infinity\n\n  def pos22 =\n    Duration.fromNanos(Long.MaxValue).fold(\"Infinity\", _ => \"Finite\") must_=== \"Finite\"\n\n  def neg1 =\n    Duration.fromNanos(-1) must_=== Duration.Zero\n\n  def inf1 =\n    Duration.Infinity.toMillis must_=== Long.MaxValue / 1000000\n\n  def inf2 =\n    Duration.Infinity.toNanos must_=== Long.MaxValue\n\n  def inf3 =\n    Duration.Infinity + Duration.Infinity must_=== Duration.Infinity\n\n  def inf4 =\n    Duration.Infinity + Duration.fromNanos(1L) must_=== Duration.Infinity\n\n  def inf5 =\n    Duration.fromNanos(1L) + Duration.Infinity must_=== Duration.Infinity\n\n  def inf6 =\n    Duration.Infinity * 10.0 must_=== Duration.Infinity\n\n  def inf7 =\n    Duration.Infinity compare Duration.Infinity must_=== 0\n\n  def inf8 =\n    Duration.Infinity compare Duration.fromNanos(1L) must_=== 1\n\n  def inf9 =\n    Duration.Infinity.isZero must_=== false\n\n  def inf10 =\n    Duration.Infinity.asScala must_=== ScalaDuration.Inf\n\n  def inf11 =\n    Duration.Infinity.asJava must_=== JavaDuration.ofSeconds(Long.MaxValue)\n\n  def inf12 =\n    Duration.Infinity.fold(\"Infinity\", _ => \"Finite\") must_=== \"Infinity\"\n\n  def inf13 =\n    Duration.Infinity * -10 must_=== Duration.Zero\n\n  def dur1 =\n    Duration.fromScala(ScalaDuration(-1L, TimeUnit.NANOSECONDS)) must_=== Duration.Zero\n\n  def dur2 =\n    Duration.fromScala(ScalaDuration.Inf) must_=== Duration.Infinity\n\n  def dur3 =\n    Duration.fromScala(ScalaDuration(1L, TimeUnit.NANOSECONDS)) must_=== Duration.fromNanos(1L)\n\n  def jdur1 =\n    Duration.fromJava(JavaDuration.ofNanos(-1L)) must_=== Duration.Zero\n\n  def jdur2 =\n    Duration.fromJava(JavaDuration.ofSeconds(Long.MaxValue)) must_=== Duration.Infinity\n\n  def jdur3 =\n    Duration.fromJava(JavaDuration.ofSeconds(Long.MaxValue, 1L)) must_=== Duration.Infinity\n\n  def jdur4 =\n    Duration.fromJava(Duration.Infinity.asJava) must_=== Duration.Infinity\n\n  def jdur5 =\n    Duration.fromJava(JavaDuration.ofSeconds(Long.MaxValue - 1)) must_=== Duration.Infinity\n\n  def jdur6 =\n    Duration.fromJava(JavaDuration.ofNanos(Long.MaxValue).plus(JavaDuration.ofNanos(1L))) must_=== Duration.Infinity\n\n  def jdur7 =\n    Duration.fromJava(JavaDuration.ofNanos(Long.MinValue).minus(JavaDuration.ofNanos(1L))) must_=== Duration.Zero\n\n  def jdur8 =\n    Duration.fromJava(JavaDuration.ofNanos(1L)) must_=== Duration.fromNanos(1L)\n\n  def mul0 =\n    Duration.Zero * 0 must_=== Duration.Zero\n\n  def mul1 =\n    Duration.Zero * 1 must_=== Duration.Zero\n\n  def mul2 =\n    Duration(1, TimeUnit.SECONDS) * 60 must_=== Duration(1, TimeUnit.MINUTES)\n}", true, (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        Make a Duration from positive nanos and check that:\n          The Duration is Finite                                               ", "\n          Copy with a negative nanos returns Zero                              ", "\n          Multiplying with a negative factor returns Zero                      ", "\n          Its stdlib representation is correct                                 ", "\n          Its JDK representation is correct                                    ", "\n          It identifies as \"zero\"                                              ", "\n          Creating it with a j.u.c.TimeUnit is identical                       ", "\n          It knows its length in ns                                            ", "\n          It knows its length in ms                                            ", "\n          max(1 ns, 2 ns) is 2 ns                                              ", "\n          min(1 ns, 2 ns) is 1 ns                                              ", "\n          max(2 ns, 1 ns) is 2 ns                                              ", "\n          min(2 ns, 1 ns) is 1 ns                                              ", "\n          10 ns + 20 ns = 30 ns                                                ", "\n          10 ns * NaN = Infinity                                               ", "\n          10 ns compared to Infinity is -1                                     ", "\n          10 ns compared to 10 ns is 0                                         ", "\n          + with positive overflow results in Infinity                         ", "\n          * with negative duration results in zero                             ", "\n          * with overflow to positive results in Infinity                      ", "\n          * with overflow to negative results in Infinity                      ", "\n          Folding picks up the correct value                                   ", "\n\n        Make a Duration from negative nanos and check that:\n          The Duration is Zero                                                 ", "\n\n        Take Infinity and check that:\n          It returns -1 milliseconds                                           ", "\n          It returns -1 nanoseconds                                            ", "\n          Infinity + Infinity = Infinity                                       ", "\n          Infinity + 1 ns = Infinity                                           ", "\n          1 ns + Infinity = Infinity                                           ", "\n          Infinity * 10 = Infinity                                             ", "\n          Infinity compared to Infinity is 0                                   ", "\n          Infinity compared to 1 ns is 1                                       ", "\n          Infinity is not zero                                                 ", "\n          It converts into the infinite s.c.d.Duration                         ", "\n          It converts into a Long.MaxValue second-long JDK Duration            ", "\n          Folding picks up the correct value                                   ", "\n          Infinity * -10 = Zero                                                ", "\n\n        Make a Scala stdlib s.c.d.Duration and check that:\n          A negative s.c.d.Duration converts to Zero                           ", "\n          The infinite s.c.d.Duration converts to Infinity                     ", "\n          A positive s.c.d.Duration converts to a Finite                       ", "\n\n        Make a Java stdlib j.t.Duration and check that:\n          A negative j.t.Duration converts to Zero                                ", "\n          A Long.MaxValue second j.t.Duration converts to Infinity                ", "\n          A nano-adjusted Long.MaxValue second j.t.Duration converts to Infinity  ", "\n          A j.t.Duration constructed from Infinity converts to Infinity           ", "\n          A Long.MaxValue - 1 second j.t.Duration converts to Infinity            ", "\n          A +ve j.t.Duration whose nano conversion overflows converts to Infinity ", "\n          A -ve j.t.Duration whose nano conversion overflows converts to Zero     ", "\n          A positive j.t.Duration converts to a Finite                            ", "\n\n        Check multiplication with finite durations:\n          Zero multiplied with zero                                            ", "\n          Zero multiplied with one                                             ", "\n          One second multiplied with 60                                        ", "\n     "})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|12", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|14", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|15", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|16", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|17", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|18", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|19", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|20", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|21", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|22", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|23", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|24", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|25", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|26", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|27", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|28", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|29", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|30", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|31", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|32", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|33", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|34", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|35", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|38", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|41", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|42", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|43", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|44", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|45", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|46", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|47", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|48", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|49", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|50", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|51", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|52", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|53", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|56", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|57", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|58", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|61", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|62", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|63", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|64", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|65", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|66", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|67", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|68", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|71", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|72", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|73"})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|14", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|15", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|16", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|17", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|18", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|19", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|20", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|21", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|22", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|23", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|24", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|25", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|26", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|27", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|28", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|29", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|30", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|31", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|32", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|33", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|34", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|35", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|38", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|41", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|42", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|43", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|44", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|45", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|46", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|47", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|48", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|49", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|50", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|51", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|52", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|53", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|56", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|57", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|58", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|61", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|62", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|63", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|64", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|65", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|66", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|67", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|68", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|71", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|72", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|73", "/home/circleci/project/core-tests/shared/src/test/scala/zio/duration/DurationSpec.scala|DurationSpec.scala|74"})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InterpolatedFragment[]{this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos1(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos2(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos3(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos4(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos5(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos6(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos7(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos8(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos9(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos10(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos11(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos12(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos13(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos14(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos15(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos16(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos17(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos18(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos19(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos20(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos21(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.pos22(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.neg1(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf1(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf2(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf3(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf4(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf5(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf6(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf7(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf8(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf9(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf10(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf11(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf12(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.inf13(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.dur1(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.dur2(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.dur3(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.jdur1(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.jdur2(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.jdur3(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.jdur4(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.jdur5(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.jdur6(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.jdur7(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.jdur8(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.mul0(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.mul1(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.mul2(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()))})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pos1", "pos2", "pos3", "pos4", "pos5", "pos6", "pos7", "pos8", "pos9", "pos10", "pos11", "pos12", "pos13", "pos14", "pos15", "pos16", "pos17", "pos18", "pos19", "pos20", "pos21", "pos22", "neg1", "inf1", "inf2", "inf3", "inf4", "inf5", "inf6", "inf7", "inf8", "inf9", "inf10", "inf11", "inf12", "inf13", "dur1", "dur2", "dur3", "jdur1", "jdur2", "jdur3", "jdur4", "jdur5", "jdur6", "jdur7", "jdur8", "mul0", "mul1", "mul2"}))));
    }

    public MatchResult<Duration> pos1() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1L)).must((Function0 & Serializable)() -> this.haveClass(ClassTag$.MODULE$.apply(Duration.Finite.class)));
    }

    public MatchResult<Duration> pos2() {
        return this.theValue((Function0 & Serializable)() -> ((Duration.Finite)Duration$.MODULE$.fromNanos(1L)).copy(-1L)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> pos3() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1L).$times(-1.0)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<scala.concurrent.duration.Duration> pos4() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1234L).asScala()).must_$eq$eq$eq((Function0 & Serializable)() -> FiniteDuration$.MODULE$.apply(1234L, TimeUnit.NANOSECONDS), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<java.time.Duration> pos5() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(2345L).asJava()).must_$eq$eq$eq((Function0 & Serializable)() -> java.time.Duration.ofNanos(2345L), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Object> pos6() {
        return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable)() -> Duration$.MODULE$.fromNanos(0L).isZero()).must_$eq$eq$eq((Function0)(JFunction0.mcZ.sp & Serializable)() -> true, Diffable$.MODULE$.booleanDiffable());
    }

    public MatchResult<Duration> pos7() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.apply(12L, TimeUnit.NANOSECONDS)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(12L), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Object> pos8() {
        return this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> Duration$.MODULE$.fromNanos(123L).toNanos()).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> 123L, Diffable$.MODULE$.longDiffable());
    }

    public MatchResult<Object> pos9() {
        return this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> Duration$.MODULE$.fromNanos(123000000L).toMillis()).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> 123L, Diffable$.MODULE$.longDiffable());
    }

    public MatchResult<Duration> pos10() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1L).max(Duration$.MODULE$.fromNanos(2L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(2L), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> pos11() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1L).min(Duration$.MODULE$.fromNanos(2L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1L), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> pos12() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(2L).max(Duration$.MODULE$.fromNanos(1L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(2L), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> pos13() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(2L).min(Duration$.MODULE$.fromNanos(1L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1L), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> pos14() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(10L).$plus(Duration$.MODULE$.fromNanos(20L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(30L), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> pos15() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(10L).$times(Double.NaN)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Object> pos16() {
        return this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> Duration$.MODULE$.fromNanos(10L).compare((Object)Duration.Infinity$.MODULE$)).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> -1, Diffable$.MODULE$.intDiffable());
    }

    public MatchResult<Object> pos17() {
        return this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> Duration$.MODULE$.fromNanos(10L).compare((Object)Duration$.MODULE$.fromNanos(10L))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 0, Diffable$.MODULE$.intDiffable());
    }

    public MatchResult<Duration> pos18() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(0x7FFFFFFFFFFFFFFEL).$plus(Duration$.MODULE$.fromNanos(42L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> pos19() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(42L).$times(-7.0)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> pos20() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(Long.MAX_VALUE).$times(3.0)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> pos21() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(Long.MAX_VALUE).$times(2.0)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<String> pos22() {
        return this.theValue((Function0 & Serializable)() -> (String)Duration$.MODULE$.fromNanos(Long.MAX_VALUE).fold((Function0 & Serializable)() -> "Infinity", (Function1 & Serializable)x$1 -> "Finite")).must_$eq$eq$eq((Function0 & Serializable)() -> "Finite", Diffable$.MODULE$.stringDiffable());
    }

    public MatchResult<Duration> neg1() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(-1L)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Object> inf1() {
        return this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> Duration.Infinity$.MODULE$.toMillis()).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> 9223372036854L, Diffable$.MODULE$.longDiffable());
    }

    public MatchResult<Object> inf2() {
        return this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> Duration.Infinity$.MODULE$.toNanos()).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> Long.MAX_VALUE, Diffable$.MODULE$.longDiffable());
    }

    public MatchResult<Duration> inf3() {
        return this.theValue((Function0 & Serializable)() -> Duration.Infinity$.MODULE$.$plus((Duration)Duration.Infinity$.MODULE$)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> inf4() {
        return this.theValue((Function0 & Serializable)() -> Duration.Infinity$.MODULE$.$plus(Duration$.MODULE$.fromNanos(1L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> inf5() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1L).$plus((Duration)Duration.Infinity$.MODULE$)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> inf6() {
        return this.theValue((Function0 & Serializable)() -> Duration.Infinity$.MODULE$.$times(10.0)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Object> inf7() {
        return this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> Duration.Infinity$.MODULE$.compare((Duration)Duration.Infinity$.MODULE$)).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 0, Diffable$.MODULE$.intDiffable());
    }

    public MatchResult<Object> inf8() {
        return this.theValue((Function0)(JFunction0.mcI.sp & Serializable)() -> Duration.Infinity$.MODULE$.compare(Duration$.MODULE$.fromNanos(1L))).must_$eq$eq$eq((Function0)(JFunction0.mcI.sp & Serializable)() -> 1, Diffable$.MODULE$.intDiffable());
    }

    public MatchResult<Object> inf9() {
        return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable)() -> Duration.Infinity$.MODULE$.isZero()).must_$eq$eq$eq((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, Diffable$.MODULE$.booleanDiffable());
    }

    public MatchResult<scala.concurrent.duration.Duration> inf10() {
        return this.theValue((Function0 & Serializable)() -> Duration.Infinity$.MODULE$.asScala()).must_$eq$eq$eq((Function0 & Serializable)() -> scala.concurrent.duration.Duration$.MODULE$.Inf(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<java.time.Duration> inf11() {
        return this.theValue((Function0 & Serializable)() -> Duration.Infinity$.MODULE$.asJava()).must_$eq$eq$eq((Function0 & Serializable)() -> java.time.Duration.ofSeconds(Long.MAX_VALUE), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<String> inf12() {
        return this.theValue((Function0 & Serializable)() -> (String)Duration.Infinity$.MODULE$.fold((Function0 & Serializable)() -> "Infinity", (Function1 & Serializable)x$2 -> "Finite")).must_$eq$eq$eq((Function0 & Serializable)() -> "Infinity", Diffable$.MODULE$.stringDiffable());
    }

    public MatchResult<Duration> inf13() {
        return this.theValue((Function0 & Serializable)() -> Duration.Infinity$.MODULE$.$times(-10.0)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> dur1() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromScala((scala.concurrent.duration.Duration)scala.concurrent.duration.Duration$.MODULE$.apply(-1L, TimeUnit.NANOSECONDS))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> dur2() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromScala((scala.concurrent.duration.Duration)scala.concurrent.duration.Duration$.MODULE$.Inf())).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> dur3() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromScala((scala.concurrent.duration.Duration)scala.concurrent.duration.Duration$.MODULE$.apply(1L, TimeUnit.NANOSECONDS))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1L), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> jdur1() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromJava(java.time.Duration.ofNanos(-1L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> jdur2() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromJava(java.time.Duration.ofSeconds(Long.MAX_VALUE))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> jdur3() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromJava(java.time.Duration.ofSeconds(Long.MAX_VALUE, 1L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> jdur4() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromJava(Duration.Infinity$.MODULE$.asJava())).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> jdur5() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromJava(java.time.Duration.ofSeconds(0x7FFFFFFFFFFFFFFEL))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> jdur6() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromJava(java.time.Duration.ofNanos(Long.MAX_VALUE).plus(java.time.Duration.ofNanos(1L)))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration.Infinity$.MODULE$, Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> jdur7() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromJava(java.time.Duration.ofNanos(Long.MIN_VALUE).minus(java.time.Duration.ofNanos(1L)))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> jdur8() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.fromJava(java.time.Duration.ofNanos(1L))).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.fromNanos(1L), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> mul0() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.Zero().$times(0.0)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> mul1() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.Zero().$times(1.0)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.Zero(), Diffable$.MODULE$.fallbackDiffable());
    }

    public MatchResult<Duration> mul2() {
        return this.theValue((Function0 & Serializable)() -> Duration$.MODULE$.apply(1L, TimeUnit.SECONDS).$times(60.0)).must_$eq$eq$eq((Function0 & Serializable)() -> Duration$.MODULE$.apply(1L, TimeUnit.MINUTES), Diffable$.MODULE$.fallbackDiffable());
    }
}

