/*
 * Decompiled with CFR 0.152.
 */
package zio;

import java.io.Serializable;
import org.specs2.concurrent.ExecutionEnv;
import org.specs2.matcher.MatchResult;
import org.specs2.matcher.MatchResult$;
import org.specs2.matcher.describe.Diffable$;
import org.specs2.specification.core.AsExecution$;
import org.specs2.specification.core.SpecStructure;
import org.specs2.specification.create.InterpolatedFragment;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import zio.IO$;
import zio.Semaphore;
import zio.Semaphore$;
import zio.TestRuntime;
import zio.ZIO;
import zio.clock.package$;

@ScalaSignature(bytes="\u0006\u0005!4A!\u0004\b\u0001#!Aa\u0003\u0001B\u0001B\u0003-q\u0003C\u0003\"\u0001\u0011\u0005!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u00031\u0001\u0011\u0005\u0011\u0007C\u0003?\u0001\u0011\u0005\u0011\u0007C\u0003@\u0001\u0011\u0005\u0011\u0007C\u0003A\u0001\u0011\u0005\u0011\u0007C\u0003B\u0001\u0011\u0005!\tC\u0003H\u0001\u0011\u0005\u0011\u0007C\u0003I\u0001\u0011\u0005\u0011\u0007C\u0003J\u0001\u0011%\u0011\u0007C\u0003K\u0001\u0011\u00051JA\u0007TK6\f\u0007\u000f[8sKN\u0003Xm\u0019\u0006\u0002\u001f\u0005\u0019!0[8\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AD\u0005\u0003+9\u00111\u0002V3tiJ+h\u000e^5nK\u0006\u0011Q-\u001a\t\u00031}i\u0011!\u0007\u0006\u00035m\t!bY8oGV\u0014(/\u001a8u\u0015\taR$\u0001\u0004ta\u0016\u001c7O\r\u0006\u0002=\u0005\u0019qN]4\n\u0005\u0001J\"\u0001D#yK\u000e,H/[8o\u000b:4\u0018A\u0002\u001fj]&$h\bF\u0001$)\t!S\u0005\u0005\u0002\u0014\u0001!)aC\u0001a\u0002/\u0005\u0011\u0011n]\u000b\u0002QA\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0005G>\u0014XM\u0003\u0002.7\u0005i1\u000f]3dS\u001aL7-\u0019;j_:L!a\f\u0016\u0003\u001bM\u0003XmY*ueV\u001cG/\u001e:f\u0003\t)\u0017'F\u00013!\r\u0019d\u0007O\u0007\u0002i)\u0011QgG\u0001\b[\u0006$8\r[3s\u0013\t9DGA\u0006NCR\u001c\u0007NU3tk2$\bCA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$\u0001\u0002'p]\u001e\f!!\u001a\u001a\u0002\u0005\u0015\u001c\u0014AA35\u0003\t)W'F\u0001D!\r\u0019d\u0007\u0012\t\u0003s\u0015K!A\u0012\u001e\u0003\tUs\u0017\u000e^\u0001\u0003KZ\n!!Z\u001c\u0002\u0005\u0015D\u0014AG8gMN,G\u000f^5oOJ+G.Z1tKN\f5-];je\u0016\u001cHc\u0001\u001aMM\")Q\n\u0004a\u0001\u001d\u0006A\u0011mY9vSJ,7\u000fE\u0003:\u001fF#\u0006-\u0003\u0002Qu\tIa)\u001e8di&|gN\r\t\u0003'IK!a\u0015\b\u0003\u0013M+W.\u00199i_J,\u0007cA+^q9\u0011ak\u0017\b\u0003/jk\u0011\u0001\u0017\u0006\u00033B\ta\u0001\u0010:p_Rt\u0014\"A\u001e\n\u0005qS\u0014a\u00029bG.\fw-Z\u0005\u0003=~\u0013aAV3di>\u0014(B\u0001/;!\r\t7\r\u0012\b\u0003'\tL!\u0001\u0018\b\n\u0005\u0011,'aA+J\u001f*\u0011AL\u0004\u0005\u0006O2\u0001\rAT\u0001\te\u0016dW-Y:fg\u0002")
public class SemaphoreSpec
extends TestRuntime {
    public SpecStructure is() {
        return this.appendSpecStructureToSpecHeader(this.title("SemaphoreSpec").title()).$up((Function0 & Serializable)() -> this.s2("\n    Make a Semaphore and\n    verify that\n      `acquire` permits sequentially $e1\n      `acquire` permits in parallel $e2\n      `acquireN`s can be parallel with `releaseN`s $e3\n      individual `acquireN`s can be parallel with individual `releaseN`s $e4\n      semaphores and fibers play ball together $e5\n      `acquire` doesn't leak permits upon cancellation $e6\n      `withPermit` does not leak fibers or permits upon cancellation $e7\n      `withPermitManaged` does not leak fibers or permits upon cancellation $e8\n    \"\"\"\n\n  def e1 = {\n    val n = 20L\n    unsafeRun(for {\n      semaphore <- Semaphore.make(n)\n      available <- IO.foreach((0L until n).toList)(_ => semaphore.acquire) *> semaphore.available\n    } yield available must_=== 0)\n  }\n\n  def e2 = {\n    val n = 20L\n    unsafeRun(for {\n      semaphore <- Semaphore.make(n)\n      available <- IO.foreachPar((0L until n).toList)(_ => semaphore.acquire) *> semaphore.available\n    } yield available must_=== 0)\n  }\n\n  def e3 =\n    offsettingReleasesAcquires(\n      (s, permits) => IO.foreach(permits)(s.acquireN).unit,\n      (s, permits) => IO.foreach(permits.reverse)(s.releaseN).unit\n    )\n\n  def e4 =\n    offsettingReleasesAcquires(\n      (s, permits) => IO.foreachPar(permits)(amount => s.acquireN(amount)).unit,\n      (s, permits) => IO.foreachPar(permits.reverse)(amount => s.releaseN(amount)).unit\n    )\n\n  def e5 = {\n    val n = 1L\n    unsafeRun(for {\n      s <- Semaphore.make(n).tap(_.acquire)\n      _ <- s.release.fork\n      _ <- s.acquire\n    } yield () must_=== (()))\n  }\n\n  /**\n   * Ported from @mpilquist work in Cats Effect (https://github.com/typelevel/cats-effect/pull/403)\n   */\n  def e6 = {\n    val n = 1L\n    unsafeRun(for {\n      s       <- Semaphore.make(n)\n      _       <- s.acquireN(2).timeout(1.milli).either\n      permits <- s.release *> clock.sleep(10.millis) *> s.available\n    } yield permits) must_=== 2\n  }\n\n  /**\n   * Ported from @mpilquist work in Cats Effect (https://github.com/typelevel/cats-effect/pull/403)\n   */\n  def e7 = {\n    val n = 0L\n    unsafeRun(for {\n      s       <- Semaphore.make(n)\n      _       <- s.withPermit(s.release).timeout(1.milli).either\n      permits <- s.release *> clock.sleep(10.millis) *> s.available\n    } yield permits must_=== 1L)\n  }\n\n  private def e8 = {\n    val test = for {\n      s       <- Semaphore.make(0)\n      _       <- s.withPermitManaged.use(_ => s.release).timeout(1.millisecond).either\n      permits <- (s.release *> clock.sleep(10.milliseconds) *> s.available)\n    } yield permits must_=== 1L\n\n    unsafeRun(test)\n  }\n\n  def offsettingReleasesAcquires(\n    acquires: (Semaphore, Vector[Long]) => UIO[Unit],\n    releases: (Semaphore, Vector[Long]) => UIO[Unit]\n  ) = {\n    val permits = Vector(1L, 0L, 20L, 4L, 0L, 5L, 2L, 1L, 1L, 3L)\n\n    unsafeRun(for {\n      semaphore     <- Semaphore.make(0L)\n      acquiresFiber <- acquires(semaphore, permits).fork\n      releasesFiber <- releases(semaphore, permits).fork\n      _             <- acquiresFiber.join\n      _             <- releasesFiber.join\n      count         <- semaphore.available\n    } yield count must_=== 0)\n  }\n\n}", true, (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    Make a Semaphore and\n    verify that\n      `acquire` permits sequentially ", "\n      `acquire` permits in parallel ", "\n      `acquireN`s can be parallel with `releaseN`s ", "\n      individual `acquireN`s can be parallel with individual `releaseN`s ", "\n      semaphores and fibers play ball together ", "\n      `acquire` doesn't leak permits upon cancellation ", "\n      `withPermit` does not leak fibers or permits upon cancellation ", "\n      `withPermitManaged` does not leak fibers or permits upon cancellation ", "\n    "})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|11", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|14", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|15", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|16", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|17", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|18", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|19", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|20", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|21"})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|14", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|15", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|16", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|17", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|18", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|19", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|20", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|21", "/home/circleci/project/core-tests/jvm/src/test/scala/zio/SemaphoreSpec.scala|SemaphoreSpec.scala|22"})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InterpolatedFragment[]{this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e1(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e2(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e3(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e4(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e5(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e6(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e7(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult())), this.asExecutionIsInterpolatedFragment((Function0 & Serializable)() -> this.e8(), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()))})), (Seq)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8"}))));
    }

    public MatchResult<Object> e1() {
        long n = 20L;
        return (MatchResult)this.unsafeRun((Function0 & Serializable)() -> Semaphore$.MODULE$.make(n).flatMap((Function1 & Serializable)semaphore -> IO$.MODULE$.foreach((Iterable)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)n)).toList(), (Function1 & Serializable)x$1 -> semaphore.acquire()).$times$greater((Function0 & Serializable)() -> semaphore.available()).map((Function1 & Serializable)available -> SemaphoreSpec.$anonfun$e1$5(this, BoxesRunTime.unboxToLong((Object)available)))));
    }

    public MatchResult<Object> e2() {
        long n = 20L;
        return (MatchResult)this.unsafeRun((Function0 & Serializable)() -> Semaphore$.MODULE$.make(n).flatMap((Function1 & Serializable)semaphore -> IO$.MODULE$.foreachPar((Iterable)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)n)).toList(), (Function1 & Serializable)x$2 -> semaphore.acquire()).$times$greater((Function0 & Serializable)() -> semaphore.available()).map((Function1 & Serializable)available -> SemaphoreSpec.$anonfun$e2$5(this, BoxesRunTime.unboxToLong((Object)available)))));
    }

    public MatchResult<Object> e3() {
        return this.offsettingReleasesAcquires((Function2<Semaphore, Vector<Object>, ZIO<Object, Nothing$, BoxedUnit>>)(Function2 & Serializable)(s, permits) -> IO$.MODULE$.foreach((Iterable)permits, (Function1 & Serializable)n -> s.acquireN(BoxesRunTime.unboxToLong((Object)n))).unit(), (Function2<Semaphore, Vector<Object>, ZIO<Object, Nothing$, BoxedUnit>>)(Function2 & Serializable)(s, permits) -> IO$.MODULE$.foreach((Iterable)permits.reverse(), (Function1 & Serializable)toRelease -> s.releaseN(BoxesRunTime.unboxToLong((Object)toRelease))).unit());
    }

    public MatchResult<Object> e4() {
        return this.offsettingReleasesAcquires((Function2<Semaphore, Vector<Object>, ZIO<Object, Nothing$, BoxedUnit>>)(Function2 & Serializable)(s, permits) -> IO$.MODULE$.foreachPar((Iterable)permits, (Function1 & Serializable)amount -> s.acquireN(BoxesRunTime.unboxToLong((Object)amount))).unit(), (Function2<Semaphore, Vector<Object>, ZIO<Object, Nothing$, BoxedUnit>>)(Function2 & Serializable)(s, permits) -> IO$.MODULE$.foreachPar((Iterable)permits.reverse(), (Function1 & Serializable)amount -> s.releaseN(BoxesRunTime.unboxToLong((Object)amount))).unit());
    }

    public MatchResult<BoxedUnit> e5() {
        long n = 1L;
        return (MatchResult)this.unsafeRun((Function0 & Serializable)() -> Semaphore$.MODULE$.make(n).tap((Function1 & Serializable)x$3 -> x$3.acquire()).flatMap((Function1 & Serializable)s -> s.release().fork().flatMap((Function1 & Serializable)x$5 -> s.acquire().map((Function1 & Serializable)x$4 -> this.theValue((Function0)(JFunction0.mcV.sp & Serializable)() -> {}).must_$eq$eq$eq((Function0)(JFunction0.mcV.sp & Serializable)() -> {}, Diffable$.MODULE$.fallbackDiffable())))));
    }

    public MatchResult<Object> e6() {
        long n = 1L;
        return this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong(this.unsafeRun((Function0 & Serializable)() -> Semaphore$.MODULE$.make(n).flatMap((Function1 & Serializable)s -> s.acquireN(2L).timeout(zio.duration.package$.MODULE$.durationInt(1).milli()).either().flatMap((Function1 & Serializable)x$6 -> s.release().$times$greater((Function0 & Serializable)() -> package$.MODULE$.sleep(zio.duration.package$.MODULE$.durationInt(10).millis())).$times$greater((Function0 & Serializable)() -> s.available()).map((Function1)(JFunction1.mcJJ.sp & Serializable)permits -> permits)))))).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> 2L, Diffable$.MODULE$.longDiffable());
    }

    public MatchResult<Object> e7() {
        long n = 0L;
        return (MatchResult)this.unsafeRun((Function0 & Serializable)() -> Semaphore$.MODULE$.make(n).flatMap((Function1 & Serializable)s -> s.withPermit(s.release()).timeout(zio.duration.package$.MODULE$.durationInt(1).milli()).either().flatMap((Function1 & Serializable)x$7 -> s.release().$times$greater((Function0 & Serializable)() -> package$.MODULE$.sleep(zio.duration.package$.MODULE$.durationInt(10).millis())).$times$greater((Function0 & Serializable)() -> s.available()).map((Function1 & Serializable)permits -> SemaphoreSpec.$anonfun$e7$6(this, BoxesRunTime.unboxToLong((Object)permits))))));
    }

    private MatchResult<Object> e8() {
        ZIO test = Semaphore$.MODULE$.make(0L).flatMap((Function1 & Serializable)s -> s.withPermitManaged().use((Function1 & Serializable)x$8 -> s.release()).timeout(zio.duration.package$.MODULE$.durationInt(1).millisecond()).either().flatMap((Function1 & Serializable)x$9 -> s.release().$times$greater((Function0 & Serializable)() -> package$.MODULE$.sleep(zio.duration.package$.MODULE$.durationInt(10).milliseconds())).$times$greater((Function0 & Serializable)() -> s.available()).map((Function1 & Serializable)permits -> SemaphoreSpec.$anonfun$e8$6(this, BoxesRunTime.unboxToLong((Object)permits)))));
        return (MatchResult)this.unsafeRun((Function0 & Serializable)() -> test);
    }

    public MatchResult<Object> offsettingReleasesAcquires(Function2<Semaphore, Vector<Object>, ZIO<Object, Nothing$, BoxedUnit>> acquires, Function2<Semaphore, Vector<Object>, ZIO<Object, Nothing$, BoxedUnit>> releases) {
        Vector permits = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 0L, 20L, 4L, 0L, 5L, 2L, 1L, 1L, 3L}));
        return (MatchResult)this.unsafeRun((Function0 & Serializable)() -> Semaphore$.MODULE$.make(0L).flatMap((Function1 & Serializable)semaphore -> ((ZIO)acquires.apply(semaphore, (Object)permits)).fork().flatMap((Function1 & Serializable)acquiresFiber -> ((ZIO)releases.apply(semaphore, (Object)permits)).fork().flatMap((Function1 & Serializable)releasesFiber -> acquiresFiber.join().flatMap((Function1 & Serializable)x$11 -> releasesFiber.join().flatMap((Function1 & Serializable)x$10 -> semaphore.available().map((Function1 & Serializable)count -> SemaphoreSpec.$anonfun$offsettingReleasesAcquires$7(this, BoxesRunTime.unboxToLong((Object)count)))))))));
    }

    public static final /* synthetic */ MatchResult $anonfun$e1$5(SemaphoreSpec $this, long available) {
        return $this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> available).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, Diffable$.MODULE$.longDiffable());
    }

    public static final /* synthetic */ MatchResult $anonfun$e2$5(SemaphoreSpec $this, long available) {
        return $this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> available).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, Diffable$.MODULE$.longDiffable());
    }

    public static final /* synthetic */ MatchResult $anonfun$e7$6(SemaphoreSpec $this, long permits) {
        return $this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> permits).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L, Diffable$.MODULE$.longDiffable());
    }

    public static final /* synthetic */ MatchResult $anonfun$e8$6(SemaphoreSpec $this, long permits) {
        return $this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> permits).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L, Diffable$.MODULE$.longDiffable());
    }

    public static final /* synthetic */ MatchResult $anonfun$offsettingReleasesAcquires$7(SemaphoreSpec $this, long count) {
        return $this.theValue((Function0)(JFunction0.mcJ.sp & Serializable)() -> count).must_$eq$eq$eq((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, Diffable$.MODULE$.longDiffable());
    }

    public SemaphoreSpec(ExecutionEnv ee) {
        super(ee);
    }
}

