/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.nomultiplereturn;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import dev.youshallnotpass.inspection.ExcludeSuppressed;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionFailures;
import dev.youshallnotpass.inspection.JavaViolations;
import dev.youshallnotpass.inspection.SimpleViolations;
import dev.youshallnotpass.inspection.badge.IwfyBadge;
import dev.youshallnotpass.inspection.sources.SourceMask;
import dev.youshallnotpass.inspections.nomultiplereturn.multiplereturns.MultipleReturn;
import dev.youshallnotpass.inspections.nomultiplereturn.multiplereturns.MultipleReturnViolations;
import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.Inspection;
import dev.youshallnotpass.plugin.IwfyException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class NoMultipleReturn
implements Inspection {
    private final SourceMask sourceMask;
    private final int threshold;
    private final List<MultipleReturn> multipleReturns;

    public NoMultipleReturn(SourceMask sourceMask, int threshold) {
        this(sourceMask, threshold, new ArrayList<MultipleReturn>());
    }

    public NoMultipleReturn(SourceMask sourceMask, int threshold, List<MultipleReturn> multipleReturns) {
        this.sourceMask = sourceMask;
        this.threshold = threshold;
        this.multipleReturns = multipleReturns;
    }

    public String name() {
        return "nomultiplereturn";
    }

    public void accept(File file) throws IwfyException {
        Path path = file.toPath();
        if (this.sourceMask.matches(path)) {
            try {
                this.multipleReturns.addAll(new JavaViolations(new JavaParser(new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.RAW)), new MultipleReturnViolations(), path.toFile()).asList());
            }
            catch (InspectionException e) {
                throw new IwfyException("Could not get the multiple return methods.", (Throwable)e);
            }
        }
    }

    public Failures failures() {
        ExcludeSuppressed<MultipleReturn> multipleReturnViolations = new ExcludeSuppressed<MultipleReturn>(new SimpleViolations<MultipleReturn>(this.multipleReturns));
        return new InspectionFailures<MultipleReturn>(multipleReturnViolations, new IwfyBadge(multipleReturnViolations, this.threshold));
    }
}

