/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.inheritancefree;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import dev.youshallnotpass.inspection.ExcludeSuppressed;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionFailures;
import dev.youshallnotpass.inspection.JavaViolations;
import dev.youshallnotpass.inspection.SimpleViolations;
import dev.youshallnotpass.inspection.badge.IwfyBadge;
import dev.youshallnotpass.inspection.sources.SourceMask;
import dev.youshallnotpass.inspections.inheritancefree.inheritances.Inheritance;
import dev.youshallnotpass.inspections.inheritancefree.inheritances.InheritanceViolations;
import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.Inspection;
import dev.youshallnotpass.plugin.IwfyException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class Inheritancefree
implements Inspection {
    private final SourceMask sourceMask;
    private final int threshold;
    private final List<Inheritance> inheritances;

    public Inheritancefree(SourceMask sourceMask, int threshold) {
        this(sourceMask, threshold, new ArrayList<Inheritance>());
    }

    public Inheritancefree(SourceMask sourceMask, int threshold, List<Inheritance> inheritances) {
        this.sourceMask = sourceMask;
        this.threshold = threshold;
        this.inheritances = inheritances;
    }

    public String name() {
        return "inheritancefree";
    }

    public void accept(File file) throws IwfyException {
        Path path = file.toPath();
        if (this.sourceMask.matches(path)) {
            try {
                this.inheritances.addAll(new JavaViolations(new JavaParser(new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.RAW)), new InheritanceViolations(), path.toFile()).asList());
            }
            catch (InspectionException e) {
                throw new IwfyException("Could not get the inheritance classes.", (Throwable)e);
            }
        }
    }

    public Failures failures() {
        ExcludeSuppressed<Inheritance> excludeSuppressed = new ExcludeSuppressed<Inheritance>(new SimpleViolations<Inheritance>(this.inheritances));
        return new InspectionFailures<Inheritance>(excludeSuppressed, new IwfyBadge(excludeSuppressed, this.threshold));
    }
}

