/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.allpublic.nonpublics;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import dev.youshallnotpass.inspections.allpublic.nonpublics.JavaNonpublic;
import dev.youshallnotpass.inspections.allpublic.nonpublics.Nonpublic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.cactoos.BiFunc;

public final class NonpublicViolations
implements BiFunc<CompilationUnit, TypeDeclaration<?>, List<Nonpublic>> {
    public List<Nonpublic> apply(CompilationUnit unit, TypeDeclaration<?> root) {
        ArrayList<Nonpublic> nonpublics = new ArrayList<Nonpublic>();
        List methods = unit.findAll(MethodDeclaration.class);
        for (MethodDeclaration method : methods) {
            Optional parentType;
            boolean interfaceMethod;
            if (method.isPublic() || (interfaceMethod = (parentType = method.findFirst(Node.TreeTraversal.PARENTS, node -> {
                Optional<Object> result = node instanceof ClassOrInterfaceDeclaration ? Optional.of((ClassOrInterfaceDeclaration)node) : Optional.empty();
                return result;
            })).isPresent() && ((ClassOrInterfaceDeclaration)parentType.get()).isInterface())) continue;
            if (method.isPrivate() || method.isProtected()) {
                method.getModifiers().stream().filter(modifier -> modifier.getKeyword() == Modifier.Keyword.PRIVATE || modifier.getKeyword() == Modifier.Keyword.PROTECTED).forEach(modifier -> nonpublics.add(new JavaNonpublic(method, (Modifier)modifier, root)));
                continue;
            }
            nonpublics.add(new JavaNonpublic(method, root));
        }
        return nonpublics;
    }
}

