/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.allpublic;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import dev.youshallnotpass.inspection.ExcludeSuppressed;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionFailures;
import dev.youshallnotpass.inspection.JavaViolations;
import dev.youshallnotpass.inspection.SimpleViolations;
import dev.youshallnotpass.inspection.badge.IwfyBadge;
import dev.youshallnotpass.inspection.sources.SourceMask;
import dev.youshallnotpass.inspections.allpublic.nonpublics.Nonpublic;
import dev.youshallnotpass.inspections.allpublic.nonpublics.NonpublicViolations;
import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.Inspection;
import dev.youshallnotpass.plugin.IwfyException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class Allpublic
implements Inspection {
    private final SourceMask sourceMask;
    private final int threshold;
    private final List<Nonpublic> nonpublics;

    public Allpublic(SourceMask sourceMask, int threshold) {
        this(sourceMask, threshold, new ArrayList<Nonpublic>());
    }

    public Allpublic(SourceMask sourceMask, int threshold, List<Nonpublic> nonpublics) {
        this.sourceMask = sourceMask;
        this.threshold = threshold;
        this.nonpublics = nonpublics;
    }

    public String name() {
        return "allpublic";
    }

    public void accept(File file) throws IwfyException {
        Path path = file.toPath();
        if (this.sourceMask.matches(path)) {
            try {
                this.nonpublics.addAll(new JavaViolations(new JavaParser(new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.RAW)), new NonpublicViolations(), path.toFile()).asList());
            }
            catch (InspectionException e) {
                throw new IwfyException("Could not get the non public methods.", (Throwable)e);
            }
        }
    }

    public Failures failures() {
        ExcludeSuppressed<Nonpublic> nonpublics = new ExcludeSuppressed<Nonpublic>(new SimpleViolations<Nonpublic>(this.nonpublics));
        return new InspectionFailures<Nonpublic>(nonpublics, new IwfyBadge(nonpublics, this.threshold));
    }
}

